package org.lsst.ccs.bus.jgroups;

import org.jgroups.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @author bamade
 */
public class GroupTopic {
    static Map<String,GroupTopic> map = new HashMap<String, GroupTopic>();

    private String topicName ;
    private JChannel channel ;
    private ReceiverAdapter adapter ;

    private GroupTopic(String topicName, String stackProperties) throws ChannelException {
        this.topicName = topicName;
        //this.adapter = adapter;
        this.channel = new JChannel(stackProperties) ;
        this.channel.connect(topicName);
        //this.channel.setReceiver(adapter);
    }


    public String getTopicName() {
        return topicName;
    }

    public JChannel getChannel() {
        return channel;
    }

    public ReceiverAdapter getAdapter() {
        return adapter;
    }

    public void setAdapter(ReceiverAdapter adapter) {
        this.adapter= adapter ;
        this.channel.setReceiver(adapter);
    }

    /**
     * Call only once for a topic otherwise else receiver argument will not be accoutned for!
     */
    public static synchronized GroupTopic create(String topic, String stackProperties) throws ChannelException {
        GroupTopic res = map.get(topic);
        if( res == null) {
            res = new GroupTopic(topic, stackProperties) ;
            map.put(topic, res);
        }
        return res ;
    }
    // TODO: make it AutoCloseable
    public void close() {
        this.channel.close();
    }

    public static synchronized void closeAll() {
        for(GroupTopic top : map.values()){
            top.close() ;
        }

    }

    public void sendMessage(Object obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.channel.send(new Message(null, null, obj));
    }
}
