package org.lsst.ccs.description.classname;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;



/**
 * Builds a Agent out of its class name.
 * @author LSST CCS Team
 */
public class ClassComponentNodeFactory implements ComponentNodeBuilder.ComponentNodeFactory {

    @Override
    public ComponentLookup buildComponentNode(String descriptionStr, Properties props) {
        try {
            Class cls = Class.forName(descriptionStr);
            ComponentNode top = new ComponentNode(cls.getSimpleName());
            Object agent = cls.getDeclaredConstructor().newInstance();
            top.setComponent(agent);
            return new ComponentLookup(top);
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getProtocol() {
        return "class";
    }
    
}
