/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Properties;
import org.codehaus.groovy.control.CompilationFailedException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.GroovyReferencePlaceHolder;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.logging.Logger;

public class GroovyComponentNodeFactory
implements ComponentNodeBuilder.ComponentNodeFactory {
    @Override
    public ComponentLookup buildComponentNode(String descriptionStr, final Properties props) {
        InputStream is;
        if (((String)descriptionStr).contains("/")) {
            throw new IllegalArgumentException("description files must be located at the root of a resource directory");
        }
        if (((String)descriptionStr).endsWith(".groovy")) {
            Logger.getLogger((String)"org.lsst.ccs.description.groovy").warn((Object)"Description file extension has to be skipped in the --description argument");
        }
        if (!((String)descriptionStr).endsWith(".groovy")) {
            descriptionStr = (String)descriptionStr + ".groovy";
        }
        if ((is = BootstrapResourceUtils.getBootstrapResource((String)descriptionStr, GroovyComponentNodeFactory.class)) == null) {
            throw new IllegalArgumentException("Could not find resource for " + (String)descriptionStr);
        }
        try {
            Binding binding = new Binding();
            binding.setProperty("ref", new Object(){

                public Object call(String in) {
                    return new GroovyReferencePlaceHolder(in);
                }
            });
            binding.setProperty("buildPropertyValue", new Object(){

                public Object call(String propertyName, Class c, Object defValue) {
                    String propertyValue = props.getProperty(propertyName);
                    if (propertyValue != null && !propertyValue.isEmpty()) {
                        return InputConversionEngine.convertArgToType((String)propertyValue, (Type)c);
                    }
                    return defValue;
                }

                public Object call(String propertyName, Object defValue) {
                    String propertyValue = props.getProperty(propertyName);
                    if (propertyValue != null && !propertyValue.isEmpty()) {
                        return InputConversionEngine.convertArgToType((String)propertyValue, defValue.getClass());
                    }
                    return defValue;
                }
            });
            binding.setProperty("buildProperties", new Object(){

                public Properties call() {
                    return props;
                }
            });
            GroovyShell shell = new GroovyShell(binding);
            InputStreamReader reader = new InputStreamReader(is, "ISO-8859-1");
            Object res = shell.evaluate((Reader)reader);
            if (!(res instanceof ComponentNode)) {
                throw new IllegalArgumentException("The described object is not a ComponentNode: " + res.getClass());
            }
            ComponentNode node = (ComponentNode)res;
            node.setProtocol(this.getProtocol());
            return new ComponentLookup(node);
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getProtocol() {
        return "groovy";
    }
}

