/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.util.BuilderSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.groovy.GroovyComponentNode;
import org.lsst.ccs.description.groovy.GroovyConstructorInvoker;
import org.lsst.ccs.description.groovy.GroovyReferencePlaceHolder;

class GroovyComponentBuilder
extends BuilderSupport {
    private final List<ComponentNode> componentsList = new ArrayList<ComponentNode>();
    private ComponentNode topNode = null;

    GroovyComponentBuilder() {
    }

    public void setParent(Object o, Object o1) {
        GroovyComponentNode parent = (GroovyComponentNode)o;
        parent.addChild((GroovyComponentNode)o1);
    }

    public Object createNode(Object name) {
        throw new IllegalStateException("class missing for node " + name);
    }

    public Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    public Object createNode(Object name, Map attributes) {
        throw new IllegalStateException("class missing for node " + name);
    }

    public Object createNode(Object name, Map attributes, Object value) {
        String key = (String)name;
        try {
            GroovyComponentNode node = new GroovyComponentNode(key, attributes, (Class)value);
            if (this.getInternalDictionary().isEmpty()) {
                this.topNode = node;
            }
            this.getInternalDictionary().add(node);
            return node;
        }
        catch (Exception ex) {
            throw new RuntimeException("at node : " + name + ": " + ex.getMessage(), ex);
        }
    }

    protected GroovyComponentNode getCurrentNode() {
        GroovyComponentNode current = (GroovyComponentNode)this.getCurrent();
        return current;
    }

    private List<ComponentNode> getInternalDictionary() {
        return this.componentsList;
    }

    public void nodeCompleted(Object parent, Object node) {
        GroovyComponentNode gNode = (GroovyComponentNode)node;
        try {
            gNode.attributes = (Map)this.resolveReferencesIn(gNode.attributes);
            String nodeName = gNode.getPath();
            if (nodeName.isEmpty()) {
                nodeName = gNode.getKey();
            }
            Object component = new GroovyConstructorInvoker().invokeConstructor(nodeName, gNode.getCls(), gNode.getAttributes(), this.topNode);
            gNode.setComponent(component);
        }
        catch (Exception ex) {
            throw new RuntimeException("At node : " + gNode.getKey() + " : " + ex.getMessage(), ex);
        }
    }

    private Object resolveReferencesIn(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GroovyReferencePlaceHolder) {
            return this.resolveReference(null, (GroovyReferencePlaceHolder)obj);
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            for (Object key : ((Map)obj).keySet()) {
                Object value = ((Map)obj).get(key);
                if (value instanceof GroovyReferencePlaceHolder) {
                    ((Map)obj).put(key, this.resolveReference((String)key, (GroovyReferencePlaceHolder)value));
                    continue;
                }
                ((Map)obj).put(key, this.resolveReferencesIn(value));
            }
            return obj;
        }
        if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Array.set(obj, i, this.resolveReferencesIn(Array.get(obj, i)));
            }
            return obj;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            ArrayList<Object> resolvedList = new ArrayList<Object>();
            for (Object o : (List)obj) {
                resolvedList.add(this.resolveReferencesIn(o));
            }
            return resolvedList;
        }
        if (Set.class.isAssignableFrom(obj.getClass())) {
            HashSet<Object> resolvedSet = new HashSet<Object>();
            for (Object o : (Set)obj) {
                resolvedSet.add(this.resolveReferencesIn(o));
            }
            return resolvedSet;
        }
        return obj;
    }

    private Object resolveReference(String key, GroovyReferencePlaceHolder ph) {
        String ref;
        String string = ref = ph.getReference() == null ? key : ph.getReference();
        if (ref == null) {
            throw new RuntimeException("cannot infer reference name");
        }
        List<ComponentNode> matchingComponents = this.getComponentsForKey(ref);
        if (matchingComponents.size() != 1) {
            matchingComponents = this.getComponentsForPath(ref);
        }
        if (matchingComponents.size() != 1) {
            throw new RuntimeException("Found " + matchingComponents.size() + " components for key " + ref + "!!! There must be only one!!!");
        }
        ComponentNode compNode = matchingComponents.get(0);
        if (compNode != null) {
            return compNode.getComponent();
        }
        throw new RuntimeException("null reference associated to " + ref);
    }

    private List<ComponentNode> getComponentsForPath(String path) {
        ArrayList<ComponentNode> result = new ArrayList<ComponentNode>();
        for (ComponentNode node : this.getInternalDictionary()) {
            if (!node.getPath().equals(path)) continue;
            result.add(node);
        }
        return result;
    }

    private List<ComponentNode> getComponentsForKey(String key) {
        ArrayList<ComponentNode> result = new ArrayList<ComponentNode>();
        for (ComponentNode node : this.getInternalDictionary()) {
            if (!node.getKey().equals(key)) continue;
            result.add(node);
        }
        return result;
    }
}

