/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.description.BaseComponent;
import org.lsst.ccs.description.ClassWithReference;
import org.lsst.ccs.description.ComponentFullConstructor;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNoConstructor;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.ComponentPartialConstructors;
import org.lsst.ccs.description.ComponentPrivateParms;
import org.lsst.ccs.description.NodeWalkComp;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class NodeBuildingTest {
    private static final String simpleParmsAPath = "simpleParmsA";

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)simpleParmsAPath);
        ComponentNode mainComponent = lookupService.getNodeByPath("");
        ComponentNoConstructor main = (ComponentNoConstructor)mainComponent.getComponent();
        Assert.assertTrue((String)("all fields should have been set : " + main.toString()), (boolean)main.allIsSet());
        Assert.assertEquals((String)"greet should be set", (Object)"Hello", (Object)main.greet);
        Assert.assertEquals((String)"otherGreet provides a setter method", (Object)"HiFromSetter", (Object)main.greetFrom);
        Map children = lookupService.getChildren(mainComponent, ComponentNoConstructor.class);
        Assert.assertTrue((children.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : children.entrySet()) {
            ComponentNoConstructor comp = (ComponentNoConstructor)entry.getValue();
            int nArgs = 0;
            if (comp instanceof ComponentPartialConstructors) {
                nArgs = 2;
            } else if (comp instanceof ComponentFullConstructor) {
                nArgs = 7;
            }
            Assert.assertEquals((String)("Constructor with " + nArgs + " arguments should have been called for " + comp), (long)nArgs, (long)comp.nArgs);
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)main, (Object)comp);
        }
    }

    @Test
    public void testInterpolatedStrings() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)"interpolatedString");
        ComponentNode mainComponent = lookupService.getNodeByPath("");
        ComponentNoConstructor mainModule = (ComponentNoConstructor)mainComponent.getComponent();
        Map children = lookupService.getChildren(mainComponent, ComponentNoConstructor.class);
        Assert.assertTrue((children.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : children.entrySet()) {
            ComponentNoConstructor comp = (ComponentNoConstructor)entry.getValue();
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)mainModule.greet, (Object)comp.greet);
        }
    }

    @Test
    public void testPrivateParmsGroovyStrategy() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)"privateParms");
        ComponentPrivateParms comp = (ComponentPrivateParms)lookupService.getComponentByPath("");
        Assert.assertEquals((long)3L, (long)comp.getI());
        Assert.assertEquals((Object)"greet", (Object)comp.getS());
        Assert.assertEquals((double)33.33, (double)comp.getD(), (double)0.1);
        Assert.assertEquals((long)4L, (long)comp.getBaseInt());
    }

    @Test
    public void testNodeBuildingOrder() throws Exception {
        ComponentNodeBuilder.buildComponentNode((String)"nodeWalkTest");
        List<String> order = NodeWalkComp.order;
        String orderS = "";
        for (String s : order) {
            orderS = orderS + s;
        }
        Assert.assertEquals((String)"components are not built in the right order", (Object)"01234567", (Object)orderS);
    }

    @Test
    public void testComponentLookup() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"deepStructure");
        Assert.assertEquals((Object)"main", (Object)lookup.getTopComponentNode().getKey());
        Object comp4 = lookup.getComponentByPath("comp1/comp4");
        Assert.assertNotNull((String)"comp3 should exist", (Object)comp4);
        Assert.assertEquals((String)"name of component should be comp4", (Object)"comp4", (Object)lookup.getNameOfComponent(comp4));
        Assert.assertTrue((boolean)lookup.containsComponent(comp4));
        Assert.assertNull((String)"non existing component", (Object)lookup.getComponentByPath("wrongName"));
        List baseCompChildren = lookup.listChildren(lookup.getNodeByPath("comp1"), BaseComponent.class);
        Assert.assertEquals((long)2L, (long)baseCompChildren.size());
        ComponentNode parent = lookup.getNodeByPath("comp6/comp7").getParent();
        Assert.assertEquals((Object)"comp6", (Object)parent.getKey());
        Assert.assertSame((Object)lookup.getComponentByPath("comp6"), (Object)parent.getComponent());
        Assert.assertEquals((String)"wrong path", (Object)"comp1/comp4/comp5", (Object)lookup.getNodeByPath("comp1/comp4/comp5").getPath());
    }

    @Test
    public void testReference() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"reference");
        ClassWithReference main = (ClassWithReference)lookup.getComponentByPath("");
        ComponentNoConstructor obj = (ComponentNoConstructor)lookup.getComponentByPath("object");
        ClassWithReference obj2 = (ClassWithReference)lookup.getComponentByPath("object2");
        ClassWithReference obj3 = (ClassWithReference)lookup.getComponentByPath("object3");
        ClassWithReference obj4 = (ClassWithReference)lookup.getComponentByPath("object4");
        ClassWithReference obj5 = (ClassWithReference)lookup.getComponentByPath("object5");
        Assert.assertSame((Object)main.obj, (Object)obj);
        Assert.assertSame((Object)obj2.obj, (Object)obj);
        Object[] array = obj2.objArray;
        Assert.assertSame((Object)obj, (Object)array[0]);
        Map<String, Object> map = obj3.objMap;
        Assert.assertSame((Object)obj, (Object)map.get("object"));
        Assert.assertSame((Object)obj2, (Object)map.get("object2"));
        Set<Object> set = obj4.objSet;
        Assert.assertTrue((boolean)set.contains(obj3));
        Assert.assertTrue((boolean)set.contains(obj2));
        Assert.assertTrue((boolean)set.contains(obj));
        List<Object> list = obj5.objList;
        Assert.assertSame((Object)obj, (Object)list.get(0));
        Assert.assertSame((Object)obj2, (Object)list.get(1));
        Assert.assertSame((Object)obj3, (Object)list.get(2));
        Assert.assertSame((Object)obj4, (Object)list.get(3));
    }

    @Test
    public void testGroovyConfiguration() throws Exception {
        Properties props = new Properties();
        int numberOfNodes = 7;
        props.setProperty("numberOfNodes", String.valueOf(7));
        props.setProperty("object0/aDouble", String.valueOf(0.0));
        props.setProperty("object6/aDouble", String.valueOf(6));
        props.setProperty("object5/intArray", "[0,1,2,3,4,5]");
        props.setProperty("object4/intArray", "[0,1,2,3,4]");
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"buildProperties", null, (Properties)props);
        List descendants = lookup.listDescendants(null, ComponentNoConstructor.class);
        Assert.assertEquals((long)numberOfNodes, (long)descendants.size());
        for (ComponentNoConstructor c : descendants) {
            ComponentNode n = lookup.getComponentNodeForObject((Object)c);
            String aDoublePropName = n.getKey() + "/aDouble";
            String aDoublePropValue = props.getProperty(aDoublePropName, "-99.");
            Assert.assertEquals((String)"Checking a double property value", (double)Double.parseDouble(aDoublePropValue), (double)c.aDouble, (double)0.001);
            String intArrayPropName = n.getKey() + "/intArray";
            String intArrayPropValue = props.getProperty(intArrayPropName, "[]");
            Assert.assertEquals((String)"Checking an int array property value", (long)((int[])InputConversionEngine.convertArgToType((String)intArrayPropValue, int[].class)).length, (long)c.intArray.length);
        }
    }

    @Test
    public void testNodeTags() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)simpleParmsAPath);
        ComponentNode node = lookupService.getNodeByPath("withPartialConstructor");
        Map tags = node.getTags();
        Assert.assertNotNull((Object)tags);
        Assert.assertEquals((Object)1, tags.get("someValue"));
        Assert.assertEquals((Object)2, tags.get("some/two"));
        Assert.assertEquals((Object)3, tags.get("three"));
    }
}

