/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.util.BuilderSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.groovy.GroovyComponentNode;
import org.lsst.ccs.description.groovy.GroovyConstructorInvoker;
import org.lsst.ccs.description.groovy.GroovyReferencePlaceHolder;

class GroovyComponentBuilder
extends BuilderSupport {
    private final Map<String, ComponentNode> internalDictionary = new HashMap<String, ComponentNode>();

    GroovyComponentBuilder() {
    }

    public void setParent(Object o, Object o1) {
        GroovyComponentNode parent = (GroovyComponentNode)o;
        parent.addChild((GroovyComponentNode)o1);
    }

    public Object createNode(Object name) {
        throw new IllegalStateException("class missing for node " + name);
    }

    public Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.EMPTY_MAP, value);
    }

    public Object createNode(Object name, Map attributes) {
        throw new IllegalStateException("class missing for node " + name);
    }

    public Object createNode(Object name, Map attributes, Object value) {
        String key = (String)name;
        if (this.getInternalDictionary().containsKey(key)) {
            throw new IllegalArgumentException("node with name : " + key + " already exists");
        }
        try {
            GroovyComponentNode node = new GroovyComponentNode(this.getCurrentNode(), key, attributes, (Class)value);
            this.getInternalDictionary().put(key, node);
            return node;
        }
        catch (Exception ex) {
            throw new RuntimeException("at node : " + name + ": " + ex.getMessage(), ex);
        }
    }

    protected GroovyComponentNode getCurrentNode() {
        GroovyComponentNode current = (GroovyComponentNode)this.getCurrent();
        return current;
    }

    protected Map<String, ComponentNode> getInternalDictionary() {
        return this.internalDictionary;
    }

    public void nodeCompleted(Object parent, Object node) {
        GroovyComponentNode gNode = (GroovyComponentNode)node;
        try {
            gNode.attributes = (Map)this.resolveReferencesIn(gNode.attributes);
            Object component = new GroovyConstructorInvoker().invokeConstructor(gNode.getCls(), gNode.getAttributes());
            gNode.setComponent(component);
        }
        catch (Exception ex) {
            throw new RuntimeException("At node : " + gNode.getKey() + " : " + ex.getMessage(), ex);
        }
    }

    private Object resolveReferencesIn(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof GroovyReferencePlaceHolder) {
            return this.resolveReference(null, (GroovyReferencePlaceHolder)obj);
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            for (Object key : ((Map)obj).keySet()) {
                Object value = ((Map)obj).get(key);
                if (value instanceof GroovyReferencePlaceHolder) {
                    ((Map)obj).put(key, this.resolveReference((String)key, (GroovyReferencePlaceHolder)value));
                    continue;
                }
                ((Map)obj).put(key, this.resolveReferencesIn(value));
            }
            return obj;
        }
        if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Array.set(obj, i, this.resolveReferencesIn(Array.get(obj, i)));
            }
            return obj;
        }
        if (List.class.isAssignableFrom(obj.getClass())) {
            ArrayList<Object> resolvedList = new ArrayList<Object>();
            for (Object o : (List)obj) {
                resolvedList.add(this.resolveReferencesIn(o));
            }
            return resolvedList;
        }
        if (Set.class.isAssignableFrom(obj.getClass())) {
            HashSet<Object> resolvedSet = new HashSet<Object>();
            for (Object o : (Set)obj) {
                resolvedSet.add(this.resolveReferencesIn(o));
            }
            return resolvedSet;
        }
        return obj;
    }

    private Object resolveReference(String key, GroovyReferencePlaceHolder ph) {
        String ref;
        String string = ref = ph.getReference() == null ? key : ph.getReference();
        if (ref == null) {
            throw new RuntimeException("cannot infer reference name");
        }
        ComponentNode compNode = this.getInternalDictionary().get(ref);
        if (compNode != null) {
            return compNode.getComponent();
        }
        throw new RuntimeException("null reference associated to " + ref);
    }
}

