/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.description.BaseComponent;
import org.lsst.ccs.description.ClassWithReference;
import org.lsst.ccs.description.ComponentFullConstructor;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNoConstructor;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.ComponentPartialConstructors;
import org.lsst.ccs.description.ComponentPrivateParms;
import org.lsst.ccs.description.NamedComponent;
import org.lsst.ccs.description.NodeWalkComp;

public class NodeBuildingTest {
    private static final String simpleParmsAPath = "simpleParmsA";

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)simpleParmsAPath);
        ComponentNoConstructor main = (ComponentNoConstructor)lookupService.getComponentByName("main");
        Assert.assertTrue((String)("all fields should have been set : " + main.toString()), (boolean)main.allIsSet());
        Assert.assertEquals((String)"greet should be set", (Object)"Hello", (Object)main.greet);
        Assert.assertEquals((String)"otherGreet provides a setter method", (Object)"HiFromSetter", (Object)main.greetFrom);
        Map children = lookupService.getChildren("main", ComponentNoConstructor.class);
        Assert.assertTrue((children.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : children.entrySet()) {
            ComponentNoConstructor comp = (ComponentNoConstructor)entry.getValue();
            int nArgs = 0;
            if (comp instanceof ComponentPartialConstructors) {
                nArgs = 2;
            } else if (comp instanceof ComponentFullConstructor) {
                nArgs = 7;
            }
            Assert.assertEquals((String)("Constructor with " + nArgs + " arguments should have been called for " + comp), (long)nArgs, (long)comp.nArgs);
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)main, (Object)comp);
        }
    }

    @Test
    public void testInterpolatedStrings() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)"interpolatedString");
        ComponentNoConstructor mainModule = (ComponentNoConstructor)lookupService.getComponentByName("main0");
        Map children = lookupService.getChildren("main0", ComponentNoConstructor.class);
        Assert.assertTrue((children.size() > 0 ? 1 : 0) != 0);
        for (Map.Entry entry : children.entrySet()) {
            ComponentNoConstructor comp = (ComponentNoConstructor)entry.getValue();
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)mainModule.greet, (Object)comp.greet);
        }
    }

    @Test
    public void testPrivateParmsGroovyStrategy() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)"privateParms");
        ComponentPrivateParms comp = (ComponentPrivateParms)lookupService.getComponentByName("main");
        Assert.assertEquals((long)3L, (long)comp.getI());
        Assert.assertEquals((Object)"greet", (Object)comp.getS());
        Assert.assertEquals((double)33.33, (double)comp.getD(), (double)0.1);
        Assert.assertEquals((long)4L, (long)comp.getBaseInt());
    }

    @Test
    public void testNodeBuildingOrder() throws Exception {
        ComponentNodeBuilder.buildComponentNode((String)"nodeWalkTest");
        List<String> order = NodeWalkComp.order;
        String orderS = "";
        for (String s : order) {
            orderS = String.valueOf(orderS) + s;
        }
        Assert.assertEquals((String)"components are not built in the right order", (Object)"01234567", (Object)orderS);
    }

    @Test
    public void testComponentLookup() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"deepStructure");
        Assert.assertEquals((Object)"main", (Object)lookup.getTopComponentNode().getKey());
        Object comp4 = lookup.getComponentByName("comp4");
        Assert.assertNotNull((String)"comp3 should exist", (Object)comp4);
        Assert.assertEquals((String)"name of component should be comp4", (Object)"comp4", (Object)lookup.getNameOfComponent(comp4));
        Assert.assertTrue((boolean)lookup.containsComponent(comp4));
        Assert.assertNull((String)"non existing component", (Object)lookup.getComponentByName("wrongName"));
        List baseCompChildren = lookup.listChildren("comp1", BaseComponent.class);
        Assert.assertEquals((long)2L, (long)baseCompChildren.size());
        Map.Entry parent = lookup.getParent("comp7");
        Assert.assertEquals((Object)"comp6", parent.getKey());
        Assert.assertSame((Object)lookup.getComponentByName("comp6"), parent.getValue());
        Assert.assertEquals((String)"wrong path", (Object)"main/comp1/comp4/comp5", (Object)lookup.getFullPathFor("comp5"));
    }

    @Test
    public void testSameNodeName() throws Exception {
        try {
            ComponentNodeBuilder.buildComponentNode((String)"sameNodeName");
            Assert.fail((String)"node with same names should be detected");
        }
        catch (Exception exception) {}
    }

    @Test
    public void testReference() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"reference");
        ClassWithReference classWithReference = (ClassWithReference)lookup.getComponentByName("main");
        ComponentNoConstructor obj = (ComponentNoConstructor)lookup.getComponentByName("object");
        ClassWithReference classWithReference1 = (ClassWithReference)lookup.getComponentByName("main1");
        Assert.assertSame((Object)classWithReference.getObject(), (Object)obj);
        Assert.assertSame((Object)classWithReference1.getObject(), (Object)obj);
    }

    @Test
    public void testDirectInjection() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"directInjection");
        ClassWithReference classWithReference = (ClassWithReference)lookup.getComponentByName("main");
        ComponentNoConstructor obj = (ComponentNoConstructor)lookup.getComponentByName("obj");
        Assert.assertSame((Object)classWithReference.getObject(), (Object)obj);
    }

    @Test
    public void testOverridenName() throws Exception {
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode((String)"namedComponents");
        NamedComponent nc = (NamedComponent)lookup.getComponentByName("baseName");
        Assert.assertNotNull((Object)nc);
        Assert.assertEquals((Object)"baseName", (Object)lookup.getNameOfComponent((Object)nc));
        nc = (NamedComponent)lookup.getComponentByName("overridenName");
        Assert.assertNotNull((Object)nc);
        Assert.assertEquals((Object)"overridenName", (Object)lookup.getNameOfComponent((Object)nc));
    }

    @Test
    public void testNodeTags() throws Exception {
        ComponentLookup lookupService = ComponentNodeBuilder.buildComponentNode((String)simpleParmsAPath);
        ComponentNode node = lookupService.getNodeByName("withPartialConstructor");
        Map tags = node.getTags();
        Assert.assertTrue((tags != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, tags.get("someValue"));
        Assert.assertEquals((Object)2, tags.get("some/two"));
        Assert.assertEquals((Object)3, tags.get("three"));
    }
}

