package org.lsst.ccs.description.groovy;

import java.lang.reflect.Constructor
import java.lang.reflect.Parameter

class GroovyConstructorInvoker {
    
    Object invokeConstructor(Class cls, Map args) {
        // Second strategy : finding the best constructor and setting other fields.
        Constructor[] ctors = cls.getConstructors();
        Map<String, Object> bestArgs = new HashMap<>();
        
        for (Constructor c : ctors) {
            Map<String, Object> matchArgs = new LinkedHashMap<>();
            Parameter[] parms = c.parameters;
            for (Parameter p : parms) {
                if (args.containsKey(p.getName())) {
                    matchArgs.put(p.getName(), args.get(p.getName()))
                } else {
                    /* 
                     * In this case one of the constructor's parameters does 
                     * not mach the provided arguments.We then clear the 
                     * matching list and move to the next constructor definition
                     */
                    matchArgs.clear();
                    break;
                }
            }
            if (matchArgs.size() > bestArgs.size()) {
                bestArgs = matchArgs;
            }
        }
        
        if (bestArgs.size() == 0) {
            // let groovy invoke empty constructor and set fields
            return cls.metaClass.invokeConstructor(args);
        } else {
            // invoke the found constructor and set other fields by hand
            
            Object res = cls.metaClass.invokeConstructor(bestArgs.values().toArray())
            
            args.keySet().removeAll(bestArgs.keySet())
            
            // Setting other fields 
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                String name = entry.getKey();
                res."$name"=entry.getValue();
            }
            return res;
        }
    }
    
}

