package org.lsst.ccs.description.groovy;

import java.util.Map;
import org.lsst.ccs.description.ComponentNode;

/**
 * Specific implementation of a ComponentNode, built from a groovy description.
 * @author bamade
 */

class GroovyComponentNode extends ComponentNode<GroovyComponentNode> {
    
    private static final long serialVersionUID = 4549184140768627636L;
    
    protected Class cls;
    
    protected Map attributes;

    GroovyComponentNode(GroovyComponentNode parent, String name, Map attributes,  Class cls) {
        super(parent, name);
        this.cls = cls;
        this.attributes = attributes;
    }
    
    public Map getAttributes() {
        return attributes;
    }
    
    public Class getCls() {
        return cls;
    }
    
    public void setCls(Class cls) { 
        this.cls = cls;
    }

}
