/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.utilities.structs.UniquePair;

public class ComponentLookup {
    private final ComponentNode top;
    private final Map<String, ComponentNode> componentNodeDict = new HashMap<String, ComponentNode>();

    public ComponentLookup(ComponentNode top) {
        this.top = top;
        this.buildDict(top);
    }

    public ComponentNode getTopComponentNode() {
        return this.top;
    }

    private void buildDict(ComponentNode<?> node) {
        this.addComponentNode(node);
        for (ComponentNode child : node.getChildren()) {
            this.buildDict(child);
        }
    }

    private void addComponentNode(ComponentNode node) {
        this.componentNodeDict.put(node.getKey(), node);
    }

    public void addComponentNodeToLookup(String name, ComponentNode node) {
        ComponentNode parent;
        ComponentNode componentNode = parent = name == null ? this.top : this.getNodeByName(name);
        if (parent == null) {
            ComponentNode.logger.warn((Object)("no node named : " + name + " : ignored"));
            return;
        }
        parent.addChild(node);
        this.buildDict(node);
    }

    public Object getComponentByName(String name) {
        ComponentNode node = this.componentNodeDict.get(name);
        if (node == null) {
            ComponentNode.logger.log(Level.WARNING, "null reference associated to {0}", (Object)name);
            return null;
        }
        return node.getComponent();
    }

    public boolean containsComponentName(String name) {
        ComponentNode node = this.componentNodeDict.get(name);
        return node != null;
    }

    public ComponentNode getNodeByName(String name) {
        ComponentNode res = this.componentNodeDict.get(name);
        if (res == null) {
            ComponentNode.logger.log(Level.WARNING, "no component named {0}", (Object)name);
        }
        return res;
    }

    public String getNameOfComponent(Object obj) {
        for (Map.Entry<String, ComponentNode> entry : this.componentNodeDict.entrySet()) {
            if (entry.getValue().getComponent() != obj) continue;
            return entry.getKey();
        }
        return null;
    }

    public <N> LinkedHashMap<String, N> getChildren(String parentName, Class<N> classFilter) {
        ComponentNode current = this.getNodeByName(parentName);
        if (current != null) {
            List children = current.getChildren();
            LinkedHashMap<String, Object> mapRes = new LinkedHashMap<String, Object>();
            for (ComponentNode child : children) {
                Object realValue = child.getComponent();
                if (classFilter != null && !classFilter.isAssignableFrom(realValue.getClass())) continue;
                Object realChild = realValue;
                String key = child.getKey();
                mapRes.put(key, realChild);
            }
            return mapRes;
        }
        return null;
    }

    public <Q> List<Q> listChildren(String parentName, Class<Q> klass) {
        return this.getChildren(parentName, klass).values().stream().collect(Collectors.toList());
    }

    public Map.Entry<String, Object> getParent(String componentName) {
        ComponentNode current = this.getNodeByName(componentName);
        if (current != null) {
            ComponentNode parent = current.getParent();
            if (parent == null) {
                return new UniquePair((Object)"_EDEN_", null);
            }
            String key = parent.getKey();
            Object value = parent.getComponent();
            return new UniquePair((Object)key, value);
        }
        return null;
    }

    public String getFullPathFor(String componentName) {
        String parentName = this.getParent(componentName).getKey();
        if ("_EDEN_".equals(parentName)) {
            return componentName;
        }
        return String.valueOf(this.getFullPathFor(parentName)) + "/" + componentName;
    }

    public boolean containsComponent(Object obj) {
        return this.getNameOfComponent(obj) != null;
    }
}

