package org.lsst.ccs.description.classname;

import java.lang.reflect.Constructor;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;



/**
 * Builds a Agent out of its class name.
 * @author LSST CCS Team
 */
public class ClassComponentNodeFactory implements ComponentNodeBuilder.ComponentNodeFactory {

    @Override
    public ComponentLookup buildComponentNode(String descriptionStr) {
        try {
            Class cls = Class.forName(descriptionStr);
            ComponentNode top = new ComponentNode(null, cls.getSimpleName());
            Object agent = null;
            if (ComponentNodeBuilder.alias != null) {
                // Finding a constructor that takes a name
                try {
                    Constructor ctr = cls.getConstructor(String.class);
                    agent = ctr.newInstance(ComponentNodeBuilder.alias);
                } catch (Exception ex) {
                    throw new RuntimeException("An alias was provided : a constructor that takes the agent name as argument is required.", ex);
                }
            } else {
                agent = cls.newInstance();
            }
            top.setComponent(agent);
            return new ComponentLookup(top);
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getProtocol() {
        return "class";
    }
    
}
