package org.lsst.ccs.description.groovy;

/**
 * CCS specific GroovyComponentBuilder class. It adds some CCS subsystem
 * specific functionality.
 *
 * All it does is to store the subsystem name as a static field as extracted 
 * from the groovy description file.
 *
 * @author The LSST CCS Team
 */
public class CCSBuilder extends GroovyComponentBuilder {

    private volatile static String subsystemName;

    public CCSBuilder(String subsystemName) {
        CCSBuilder.subsystemName = subsystemName;
    }

    public static String getSubsystemName() {
        return subsystemName;
    }
    
}
