/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.ComponentPrivateParms;
import org.lsst.ccs.description.ComponentWithMapParms;
import org.lsst.ccs.description.ComponentWithRefParms;
import org.lsst.ccs.description.ComponentWithVarargsParms;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.description.SimpleParmsNoCtor;

public class NodeBuildingTest {
    private static final String simpleParmsAPath = "simpleParmsA";
    private static final String mapParmsAPath = "mapParmsA";
    private static final String varargsParmsAPath = "varargsParmsA";
    private static final String refParmsAPath = "refParms";

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)simpleParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentLookupService lookupService = new ComponentLookupService(top);
        SimpleParmsNoCtor mainModule = (SimpleParmsNoCtor)top.getIndirect((Object)"main");
        LinkedHashMap children = lookupService.getChildren("main", SimpleParmsNoCtor.class);
        for (Map.Entry entry : children.entrySet()) {
            Object m = entry.getValue();
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)mainModule, m);
        }
    }

    @Test
    public void testMapParmsDirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)mapParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithMapParms mainModule = (ComponentWithMapParms)top.getIndirect((Object)"main");
        Assert.assertNotEquals((String)("min should be set " + mainModule.min), (long)0L, (long)mainModule.min);
        Assert.assertNotEquals((String)("max should be set " + mainModule.max), (long)0L, (long)mainModule.max);
    }

    @Test
    public void testvarargsParmsADirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)varargsParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithVarargsParms m1 = (ComponentWithVarargsParms)top.getIndirect((Object)"varargs1");
        ComponentWithVarargsParms m2 = (ComponentWithVarargsParms)top.getIndirect((Object)"varargs2");
        Assert.assertEquals((String)"varargs1 length : ", (long)2L, (long)m1.getParmsSize());
        Assert.assertEquals((String)"varargs2 length : ", (long)3L, (long)m2.getIntParmsSize());
    }

    @Test
    public void testRefParms() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)refParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithRefParms main = (ComponentWithRefParms)top.getIndirect((Object)"main");
        ComponentWithRefParms compA = (ComponentWithRefParms)top.getIndirect((Object)"compA");
        ComponentWithRefParms compB = (ComponentWithRefParms)top.getIndirect((Object)"compB");
        SimpleParmsNoCtor compA1 = (SimpleParmsNoCtor)top.getIndirect((Object)"compA1");
        SimpleParmsNoCtor compA2 = (SimpleParmsNoCtor)top.getIndirect((Object)"compA2");
        SimpleParmsNoCtor compB1 = (SimpleParmsNoCtor)top.getIndirect((Object)"compB1");
        SimpleParmsNoCtor compB2 = (SimpleParmsNoCtor)top.getIndirect((Object)"compB2");
        Assert.assertTrue((main.getLeft() == compA1 ? 1 : 0) != 0);
        Assert.assertTrue((main.getRight() == compB2 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getLeft() == compA1 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getRight() == compA2 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getOther() == null ? 1 : 0) != 0);
        Assert.assertTrue((compB.getLeft() == compB1 ? 1 : 0) != 0);
        Assert.assertTrue((compB.getRight() == compB2 ? 1 : 0) != 0);
        Assert.assertTrue((compB.getOther() == compA1 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolatedStrings() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"interpolatedString");
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentLookupService lookupService = new ComponentLookupService(top);
        SimpleParmsNoCtor mainModule = (SimpleParmsNoCtor)top.getIndirect((Object)"main0");
        int i = 1;
        while (i < 4) {
            Assert.assertNotNull((Object)lookupService.getComponentByName("comp" + i));
            ++i;
        }
        LinkedHashMap children = lookupService.getChildren("main0", SimpleParmsNoCtor.class);
        Assert.assertEquals((long)3L, (long)children.size());
        for (Map.Entry entry : children.entrySet()) {
            Assert.assertEquals((String)("main module and " + (String)entry.getKey() + " child should be equal"), (Object)mainModule, entry.getValue());
        }
    }

    @Test
    public void testPrivateParmsGroovyStrategy() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"privateParms");
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        new ComponentLookupService(top);
        ComponentPrivateParms comp = (ComponentPrivateParms)top.getIndirect((Object)"main");
        Assert.assertEquals((long)3L, (long)comp.getI());
        Assert.assertEquals((Object)"greet", (Object)comp.getS());
        Assert.assertEquals((double)33.33, (double)comp.getD(), (double)0.1);
        Assert.assertEquals((long)4L, (long)comp.getBaseInt());
    }
}

