package org.lsst.gruth.jutils;


import java.math.BigDecimal;
import java.util.Map;

/**
 * @author bamade
 */
public class DblParm extends HollowParm<Double>{
    /**
	 * 
	 */
	private static final long serialVersionUID = -6826726577379552554L;
	private BigDecimal bigVal ;
    public DblParm() {
    }

    public DblParm(Double value) {
        super(value);
    }
    public DblParm(Double value, Map<?,?> map) {
        super(value, map);
    }

    public DblParm(BigDecimal value) {
        this.bigVal = value ;
        set = true ;
    }
    public DblParm(BigDecimal value, Map<?,?> map) {
        this(value);
        setProperties(map);
    }

    public DblParm(String strVal) throws NumberFormatException{
        this(new BigDecimal(strVal)) ;
    }
    public DblParm(String strVal, Map<?,?> map) throws NumberFormatException{
        this(new BigDecimal(strVal), map) ;
    }

    @Override
    public Double getValue() {
        if(bigVal != null) {
            return bigVal.doubleValue();
        }
        return value ;
    }

    public BigDecimal asBigDecimal() {
        if(isSet()) {
            if(bigVal != null) {
                return bigVal ;
            }
            return BigDecimal.valueOf(value) ;
        }
        return null ;
    }

    @Override
    public void setValue(Double value) {
        if(readOnly) return ;
        super.setValue(value);
        bigVal = null ;
    }

    public void setValue(BigDecimal bigVal) {
        if(readOnly) return ;
        this.bigVal = bigVal ;
        set = true ;
        this.value = null ;
    }

    public void setValue(Integer val) {
        if(readOnly) return ;
        this.bigVal = new BigDecimal(val) ;
        set = true ;
        this.value = null ;
    }

    public void setValue(String strVal) throws NumberFormatException{
        if(readOnly) return ;
        this.setValue(new BigDecimal(strVal));
    }

    @Override
    public String toString() {
        if(bigVal != null) {
            return bigVal.toPlainString();
        }
        return super.toString() ;
    }
    @Override
    public Class<Double> getValueClass() {
        return Double.class ;
    }
}
