package org.lsst.gruth.jutils;


import java.util.Map;

/**
 * @author bamade
 */
public class BoolParm  extends HollowParm<Boolean>{

    public BoolParm() {
        super(Boolean.FALSE);
    }

    public BoolParm(Boolean value) {
        super(value) ;
    }

    public BoolParm(String strBool) {
        this(Boolean.valueOf(strBool)) ;
    }

    public BoolParm(Boolean value, Map<?,?> map) {
        super(value, map) ;
    }

    public BoolParm(String strBool,Map<?,?> map) {
        this(Boolean.valueOf(strBool), map) ;
    }

    public void setValue(String strBool) {
        this.setValue(Boolean.valueOf(strBool));
    }

    @Override
    public void setNullValue(){
        this.setValue(Boolean.FALSE);
    }

    @Override
    public void clear() {
        this.setValue(Boolean.FALSE);
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class ;
    }
}
