package org.lsst.gruth.jutils;


import java.io.Serializable;
import java.util.Map;

/**
 * A parameter which is an array.
 * these keep their initial type used for creation (so no no-arg contructor).
 *
 * @author bamade
 */
// Date: 02/10/12

public class ArrayParm<E extends Serializable> extends HollowParm<E>{
    
    /**
	 * 
	 */
	private static final long serialVersionUID = -6299555651728683638L;
	// The type of the array
    private final Class<E> initialType ;

    public ArrayParm(Class<E> klass, E args) {
        super(args);
        initialType = klass;
    }
    
    public ArrayParm(Class<E> klass, E args, Map map){
        super(args, map) ;
        initialType = klass ;
    }
    
    @Override
    public Class getValueClass() {
        return initialType;
    }

}
