package org.lsst.gruth.jutils;


import java.util.Map;

/**
 * @author bamade
 */
public class IntParm extends HollowParm<Integer> {
    /**
	 * 
	 */
	private static final long serialVersionUID = 4902257608591992708L;

	public IntParm() {
        super();
    }

    public IntParm(Integer value) {
        super(value);
    }
    public IntParm(Integer value, Map<?,?> map) {
        super(value, map);
    }

    public IntParm(String valStr) throws NumberFormatException {
        super(Integer.parseInt(valStr));
    }
    public IntParm(String valStr, Map<?,?> map) throws NumberFormatException {
        super(Integer.parseInt(valStr), map) ;
    }

    public void setValue(String valStr) throws NumberFormatException {
        if(readOnly) return ;
        super.setValue(Integer.parseInt(valStr));
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }
}
