/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.Map;
import org.lsst.ccs.framework.annotations.ConfigChanger;

public class ComponentWithMapParms {
    int min;
    int max;

    public ComponentWithMapParms(String name, Map<String, Integer> map) {
        this.setMinMax(map);
    }

    final void setMin(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("min should be positive");
        }
        this.min = min;
    }

    final void setMax(int max) {
        if (max > 2048) {
            throw new IllegalArgumentException("max should be less than 2048");
        }
        this.max = max;
    }

    @ConfigChanger
    public final void setMinMax(Map<String, Integer> changes) {
        int valMax;
        int valMin = changes.get("min");
        if (valMin > (valMax = changes.get("max").intValue())) {
            throw new IllegalArgumentException("max less that min");
        }
        this.setMin(valMin);
        this.setMax(valMax);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModuleWithMapParms{");
        sb.append("min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append('}');
        return sb.toString();
    }
}

