package org.lsst.ccs.description;

import java.util.ArrayList;
import org.lsst.gruth.jutils.MapArgs;

/**
 * This class is to replace the initial <TT>ComponentNode</TT> class.
 * Each node contains only an actual object that can be used by the application.
 * (contrary to <TT>DescriptiveNode</TT> that contains only a description)
 * @author bamade
 */
// Date: 22/07/2014

public class EffectiveNode extends ComponentNode<EffectiveNode, Object> {
    
    //todo: add the initialMap from description?
    public EffectiveNode(IndirectMap<String, ComponentNode> registry, String name, String key,  Object value, DescriptiveNode descriptiveNode) {
        super(registry, name, key, MapArgs.EMPTY_MAPARGS,  value);
    }

    /**
     * @param registry
     * @param children
     * @param parent
     * @throws NullPointerException
     * @throws IllegalArgumentException
     */
    public void adoptOrphans(/*NotNull*/IndirectMap<String, ComponentNode> registry, /*NotNull*/ArrayList<EffectiveNode> children, EffectiveNode parent)
            throws NullPointerException, IllegalArgumentException {
        for (EffectiveNode child : children) {
            if (child.parent == null) {
                //TODO: verify inconsitencies between keys!
                //TODO: modify in a coherent way with addChild
                if (child.nodeDict != registry) {
                    registry.putAll(child.getNodeDict());
                    child.nodeDict = registry;
                }
                child.parent = parent;
            } else {
                throw new IllegalArgumentException("child added but is part of another node tree");
            }
        }
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

}
