/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.ComponentWithMapParms;
import org.lsst.ccs.description.ComponentWithRefParms;
import org.lsst.ccs.description.ComponentWithSimpleParms;
import org.lsst.ccs.description.ComponentWithVarargsParms;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;

public class NodeBuildingTest {
    private static final String simpleParmsAPath = "simpleParmsA";
    private static final String mapParmsAPath = "mapParmsA";
    private static final String varargsParmsAPath = "varargsParmsA";
    private static final String refParmsAPath = "refParms";

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)simpleParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentLookupService lookupService = new ComponentLookupService(top);
        ComponentWithSimpleParms mainModule = (ComponentWithSimpleParms)top.getIndirect((Object)"main");
        HashMap<String, Object> modules = new HashMap<String, Object>();
        modules.put("StringValues", lookupService.getComponentByName("StringValues"));
        modules.put("litterals", lookupService.getComponentByName("litterals"));
        modules.put("partLitterals", lookupService.getComponentByName("partLitterals"));
        lookupService.getChildren("main", ComponentWithSimpleParms.class);
        for (Map.Entry entry : modules.entrySet()) {
            Object m = entry.getValue();
            Assert.assertEquals((String)("main module and " + m + " child should be equal"), (Object)mainModule, m);
        }
        ComponentWithSimpleParms arrayModule = (ComponentWithSimpleParms)top.getIndirect((Object)"withArrays");
        Assert.assertArrayEquals((int[])new int[]{4, 5, 6}, (int[])arrayModule.getIntArray());
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.14}, (double[])arrayModule.getDblArray(), (double)0.1);
    }

    @Test
    public void testMapParmsDirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)mapParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithMapParms mainModule = (ComponentWithMapParms)top.getIndirect((Object)"main");
        Assert.assertNotEquals((String)("min should be set " + mainModule.min), (long)0L, (long)mainModule.min);
        Assert.assertNotEquals((String)("max should be set " + mainModule.max), (long)0L, (long)mainModule.max);
    }

    @Test
    public void testvarargsParmsADirectBuild() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)varargsParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithVarargsParms m1 = (ComponentWithVarargsParms)top.getIndirect((Object)"varargs1");
        ComponentWithVarargsParms m2 = (ComponentWithVarargsParms)top.getIndirect((Object)"varargs2");
        Assert.assertEquals((String)"varargs1 length : ", (long)2L, (long)m1.getParmsSize());
        Assert.assertEquals((String)"varargs2 length : ", (long)3L, (long)m2.getIntParmsSize());
    }

    @Test
    public void testRefParms() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)refParmsAPath);
        EffectiveNode top = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        ComponentWithRefParms main = (ComponentWithRefParms)top.getIndirect((Object)"main");
        ComponentWithRefParms compA = (ComponentWithRefParms)top.getIndirect((Object)"compA");
        ComponentWithRefParms compB = (ComponentWithRefParms)top.getIndirect((Object)"compB");
        ComponentWithSimpleParms compA1 = (ComponentWithSimpleParms)top.getIndirect((Object)"compA1");
        ComponentWithSimpleParms compA2 = (ComponentWithSimpleParms)top.getIndirect((Object)"compA2");
        ComponentWithSimpleParms compB1 = (ComponentWithSimpleParms)top.getIndirect((Object)"compB1");
        ComponentWithSimpleParms compB2 = (ComponentWithSimpleParms)top.getIndirect((Object)"compB2");
        Assert.assertTrue((main.getLeft() == compA1 ? 1 : 0) != 0);
        Assert.assertTrue((main.getRight() == compB2 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getLeft() == compA1 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getRight() == compA2 ? 1 : 0) != 0);
        Assert.assertTrue((compA.getOther() == null ? 1 : 0) != 0);
        Assert.assertTrue((compB.getLeft() == compB1 ? 1 : 0) != 0);
        Assert.assertTrue((compB.getRight() == compB2 ? 1 : 0) != 0);
        Assert.assertTrue((compB.getOther() == compA1 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolatedStrings() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"interpolatedString");
        Assert.assertNotNull((Object)descriptiveNode.getNodeByName("main4"));
    }
}

