package org.lsst.gruth.jutils;

import java.util.ArrayList;
import java.util.Arrays;

import java.util.Collection;
import java.util.Map;

/**
 * can hold  a list of values (cannot be used with a list of HollowParm)
 * @author bamade
 */
// Date: 01/10/12

public class ListParm  extends HollowParm<ArrayList>{
    public ListParm() {
        super() ;
    }

    public ListParm(Collection col) {
        super(new ArrayList(col)) ;
    }
    public ListParm(Collection col, Map<?,?> props) {
        super(new ArrayList(col), props) ;
    }

    public void setValue(Collection col) {
        if(readOnly) return ;
        super.setValue(new ArrayList(col));
    }

    public void setValue(Object... vals) {
        if(readOnly) return ;
        super.setValue(new ArrayList(Arrays.asList(vals)));
    }
    @Override
    public Class<ArrayList> getValueClass() {
        return ArrayList.class;
    }
}
