package org.lsst.ccs.description;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.utilities.reflect.ConstructorUtils;
import org.lsst.gruth.jutils.BuiltParm;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.MapArgs;
import org.lsst.gruth.jutils.NamedRefParm;

/**
 * A Subsystem DescriptiveNode contains all the needed information to build
 * an EffectiveNode.
 * A DescriptiveNode contains the class name of the object to be created on this
 * node and all the attributes needed to build it.
 * 
 */
public class DescriptiveNode extends ComponentNode<DescriptiveNode,Class> implements Cloneable {

    private String subsystemName, protocol;    
    // -- the descriptive node is currently stored in configuration database
    private transient Constructor constructor;
    
    public DescriptiveNode(DescriptiveNode parent, String name, Class value) {
        this(parent, name, MapArgs.EMPTY_MAPARGS, value);
    }

    public DescriptiveNode(DescriptiveNode parent, String name, Map attributes, Class value) {
        super(parent, name, attributes, value);
    }

    public DescriptiveNode clone() {
        Map newAttributes = attributes;
        if (attributes instanceof MapArgs) {
            newAttributes = ((MapArgs) attributes).clone();
        }
        DescriptiveNode res = new DescriptiveNode((DescriptiveNode) null, name, newAttributes, realValue) ;

        if (children != null) {
            for (DescriptiveNode child : children) {
                DescriptiveNode newChild = child.clone();
                newChild.parent = null;
                res.addChild(newChild);
            }
        }

        return  res;
    }

    public String getSubsystemName() {
        return subsystemName;
    }
    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getProtocol() {
        return protocol;
    }
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
    
    public void setConstructor() {
        // build the list of parameter classes
        List<Class<?>> parameterClasses = new ArrayList<>();
        Set<Map.Entry> keyVals = getAttributes().entrySet();
        for (Map.Entry entry : keyVals) {
            Object val = entry.getValue();
            if ( val == null ) {
                parameterClasses.add(ConstructorUtils.NULL_CLASS);
            } else if (val instanceof NamedRefParm) {
                parameterClasses.add((Class)getIndirect(((HollowParm<String>)val).getValue()));
            } else if (val instanceof HollowParm) {
                parameterClasses.add(((HollowParm)val).getValueClass());
            } else if (val instanceof BuiltParm) {
                parameterClasses.add(((BuiltParm)val).fullValue(nodeDict).getClass());
            } else { // litteral
                // BigDecimal case
                if (val.getClass().equals(BigDecimal.class)) {
                    parameterClasses.add(Double.class);
                }
                else {
                    parameterClasses.add(val.getClass());
                }
            }
        }
        Constructor ctor =  ConstructorUtils.getMatchingConstructor(getRealValue(), parameterClasses.toArray(new Class<?>[parameterClasses.size()]));
        
        if (ctor == null) {
            throw new IllegalArgumentException("could not find matching constructor with arguments : " + parameterClasses 
                    +  " for node : " + getKey() 
                    + " of class " + getRealValue());
        }
        this.constructor = ctor;
    }
    
    public Constructor getConstructor() {
        return constructor;
    }
    
    
    
}
