package org.lsst.ccs.description;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.lsst.ccs.description.ComponentNode.IndirectHash;
import org.lsst.gruth.jutils.EmptyParmException;
import org.lsst.gruth.jutils.MapArgs;

/**
 * Builds <TT>EffectiveNode</TT> structure of actual objects out of <TT>DescriptiveNode</TT> structure.
 * <P/>
 * The tree is built "from the ground up" (starting from the "leaves").
 * @author bamade
 *
 */
public class ComponentFactory {
    public DescriptiveNode topNode;

    /**
     * creates a Factory that will operate from a subtree of this topNode
     * @ImplNote
     * Keep this constructor and deprecate buildObjectTreeFrom
     * @param topNode
     */
    public ComponentFactory(DescriptiveNode topNode) {
        this.topNode = topNode;
    }

    EffectiveNode build() {
        EffectiveNode effectiveNode = buildObjectTreeFrom( topNode);
        return effectiveNode;
    }
    
    
    

    /**
     * builds an <TT>EffectiveNode</TT> tree from a DescriptiveNode
     * @ImplNote
     * todo: deprecate and build from the topNode only.
     * @param node
     * @return
     */
    EffectiveNode buildObjectTreeFrom(DescriptiveNode node) {
        IndirectMap<String, ComponentNode> map = new IndirectHash<>();
        EffectiveNode res = buildFrom(map, node);
        return res;
    }

    /**
     * builds an EffectiveNode from a Descriptive Node.
     * the build is operating "from the ground up" (children are build before parent).
     *
     * @param registry a Map common to all Nodes. This means that the build of a Node can use a reference to an Object build during child node build (or before)
     * @param node
     * @return
     */
    //ComponentNode buildFrom(IndirectMap<String, Object> registry, ComponentNode node) {
    EffectiveNode buildFrom(IndirectMap<String, ComponentNode> registry, DescriptiveNode node) {
        //start from children
        ArrayList<EffectiveNode> newChildren = null;
        ArrayList<DescriptiveNode> children = node.getChildren();
        if (children != null) {
            int nbChildren = children.size();
            if (nbChildren > 0) {
                newChildren = new ArrayList<EffectiveNode>(nbChildren);
                for (DescriptiveNode child: children) {
                    newChildren.add(buildFrom(registry, child));
                }
            }
        }
        // gets the key
        String key = node.getKey();

        // gets the parameters of constructor
        Object actualNodeValue = null;
        Map rawArgs = node.getAttributes();
        if (rawArgs instanceof MapArgs) {
            MapArgs originArgs = (MapArgs) rawArgs;
            if ( originArgs.isSafe()) {
                // means that we can't use the default groovy strategy : null ctor + map
                // builds the object value
                //println "doing constructor call $clazz"
                Constructor c = node.getConstructor();
//                try {
                    Object[] arrayArgs = originArgs.asFullArray(registry);
                    actualNodeValue = createNewInstance(registry, key, c, arrayArgs);
//                    //change that stupid test
//                    if(! valuesOnly) {
//                        originArgs = originArgs.asFullMap(registry);
//                        actualNodeValue = createWithNamedParameters(registry, key, c, originArgs);
//                    }
//                    if(actualNodeValue == null) {
//                        // we get the actual list of arguments
//                        originArgs = originArgs.asFullMap(registry);
//                        Tracer.trace(Tracer.NODE_EVAL, key, "calling constructor for", clazz, "with args :", originArgs);
//                        actualNodeValue = createWithNamedParameters(registry, key, c, originArgs);
//                    }
//                } catch( Exception exc) {
//                    throw new ConstructorInvocationException(
//                    + originArgs, exc);
//                }
            } else {
                throw new EmptyParmException("arguments list with empty values");
            }
        } else {
            throw new IllegalArgumentException("node with arguments that are not of type MapARgs");
        }
        //TODO : else
        // builds the object value
        // builds a new Component Node which should be an Effective Node
        //ComponentNode res = ComponentNode.createOrphan(registry, node.getName(), key, actualNodeValue)
        //todo: add the properties from the descriptiveNode ?
        EffectiveNode res = new EffectiveNode(registry, node.getName(), key, actualNodeValue,node);
        // register children
        if (newChildren != null) {
            res.adoptOrphans(registry, newChildren, res);
        }
        return res;

    }
    
    public static Object createNewInstance(IndirectMap registry, String key, Constructor c, Object[] args) {
        Object[] newArray = args;
        try {
            if (c.isVarArgs()) {
                // Constructor is a varargs : varargs arguments have to be grouped together in an array.
                int varargsStartIndex = c.getParameterCount() - 1;
                int varargsLength = args.length - varargsStartIndex;
                Class varargsClass = c.getParameterTypes()[varargsStartIndex];
                Object[] varargs = new Object[varargsLength];
                for (int i = 0; i<varargsLength; i++) {
                    varargs[i] = args[varargsStartIndex+i];
                }
                newArray = Arrays.copyOf(args, c.getParameterCount());
                newArray[newArray.length-1]= Arrays.copyOf(varargs, varargs.length, varargsClass);
            }
            return c.newInstance(newArray);
        } catch(Exception ex) {
            String s = "(";
            for (int i = 0 ; i <newArray.length; i++) {
                s+= args[i].getClass() +", "; 
            }
            s= s.substring(0, s.length()-2)+")";
            throw new ConstructorInvocationException("error invoking constructor " + c + " for node " + key + " and arguments of type : " + s, ex);
        }
    } 
}

