/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.logging.Level;
import java.util.logging.Logger;

public enum Tracer {
    NODE_BUILD,
    NODE_EVAL,
    NODE_MODIF,
    NODE_CALLS,
    TEST_BUILD,
    TEST_EVAL,
    PRE,
    POST,
    XPECT;

    int bitPosition = 1 << this.ordinal();
    static final int traceMask;
    static Logger logger;

    static {
        int mask = 0;
        String traceSpecs = System.getenv("gruth.traces");
        if (traceSpecs == null) {
            traceSpecs = System.getProperty("gruth.traces");
        }
        if (traceSpecs != null) {
            String[] specs;
            String[] stringArray = specs = traceSpecs.split(",");
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                String spec = stringArray[n2];
                Tracer tracer = Tracer.valueOf(spec);
                mask |= tracer.bitPosition;
                ++n2;
            }
        }
        traceMask = mask;
        logger = Logger.getLogger("org.lsst.gruth");
    }

    public static void trace(Tracer tracer, Object ... args) {
        if ((traceMask & tracer.bitPosition) == 1) {
            StringBuilder builder = new StringBuilder();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj == null) {
                    builder.append(" %no trace (null value)% ");
                }
                try {
                    builder.append(" $obj");
                }
                catch (Exception exception) {
                    builder.append(" %no trace (null value in toString() method)% ");
                }
                ++n2;
            }
            Level level = logger.getLevel();
            if (level != null && level.intValue() <= Level.INFO.intValue()) {
                logger.log(level, builder.toString());
            } else {
                System.out.println(builder.toString());
            }
        }
    }
}

