/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.SerializedComponentNodeFactory;

public class ComponentNodeBuilder {
    private static final HashMap<String, ComponentNodeFactory> factories = new HashMap();

    static {
        ComponentNodeBuilder.registerComponentNodeFactory(new SerializedComponentNodeFactory());
        ComponentNodeBuilder.registerComponentNodeFactory(new org.lsst.ccs.description.groovy.ComponentNodeFactory());
    }

    public static void registerComponentNodeFactory(ComponentNodeFactory factory) {
        factories.put(factory.getProtocol(), factory);
    }

    public static DescriptiveNode buildDescriptiveNode(String fullDescription) {
        ComponentNodeFactory factory;
        String descriptionProtocol = "groovy";
        String descriptionString = fullDescription;
        if (fullDescription.contains(":")) {
            descriptionProtocol = fullDescription.substring(0, fullDescription.indexOf(58));
            descriptionString = fullDescription.substring(fullDescription.indexOf(58) + 1);
        }
        if ((factory = factories.get(descriptionProtocol)) == null) {
            throw new IllegalArgumentException("There is no registered ComponentNodeFactory for protocol " + descriptionProtocol);
        }
        return factory.buildDescriptiveNode(descriptionString);
    }

    public static interface ComponentNodeFactory {
        public DescriptiveNode buildDescriptiveNode(String var1);

        public String getProtocol();
    }
}

