/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.description.IndirectMap;
import org.lsst.ccs.description.Tracer;
import org.lsst.ccs.framework.TreeWalkerDiag;

class ComponentNode<T extends ComponentNode<T, Z>, Z>
implements Serializable {
    protected static final Logger logger = Logger.getLogger("org.lsst.ccs.description");
    protected IndirectMap<String, ComponentNode> nodeDict;
    protected String key;
    protected T parent;
    protected ArrayList<T> children = new ArrayList();
    protected String name;
    protected Z realValue;
    protected Map attributes;

    public IndirectMap getNodeDict() {
        return this.nodeDict;
    }

    @Deprecated
    public void setNodeDict(IndirectMap<String, ComponentNode> registry) {
        this.nodeDict = registry;
    }

    protected void checkDict(T parent, String name, Map attributes) {
        IndirectHash<String, ComponentNode> dict = parent == null ? new IndirectHash<String, ComponentNode>() : ((ComponentNode)parent).getNodeDict();
        this.setDict(dict, name, attributes);
    }

    protected void setDict(IndirectMap<String, ComponentNode> registry, String name, Map attributes) {
        Object valName;
        String keyStr = name;
        if (attributes != null && (valName = attributes.get("name")) != null) {
            keyStr = String.valueOf(valName);
        }
        this.key = keyStr;
        this.name = keyStr;
        registry.put(keyStr, this);
        this.nodeDict = registry;
    }

    @Deprecated
    ComponentNode(T parent, String name) {
        this(parent, name, null, null);
        System.out.println("*** Why are we using this constructor. " + name);
    }

    ComponentNode(T parent, String name, Z value) {
        this(parent, name, null, value);
    }

    @Deprecated
    ComponentNode(T parent, String name, Map attributes) {
        this(parent, name, attributes, null);
        System.out.println("*** Why are we using this constructor. " + name + " " + attributes);
    }

    ComponentNode(T parent, String name, Map attributes, Z value) {
        this.parent = parent;
        this.attributes = attributes;
        this.realValue = value;
        this.checkDict(parent, name, attributes);
    }

    protected ComponentNode(IndirectMap<String, ComponentNode> registry, String name, String key, Map attributes, Z value) {
        this.attributes = attributes;
        this.realValue = value;
        this.setDict(registry, name, attributes);
    }

    public String getName() {
        return this.name;
    }

    public Z getRealValue() {
        return this.realValue;
    }

    public ComponentNode getNodeByName(String name) {
        return (ComponentNode)this.nodeDict.get(name);
    }

    public Object getIndirect(Object key) {
        Object node = this.nodeDict.get(key);
        if (node instanceof ComponentNode) {
            return ((ComponentNode)node).getRealValue();
        }
        return node;
    }

    public Iterator<String> getAllKeys() {
        return this.nodeDict.keySet().iterator();
    }

    public Iterable<String> getAllNames() {
        Collection col = this.nodeDict.values();
        HashSet<String> res = new HashSet<String>();
        for (Object obj : col) {
            if (!(obj instanceof ComponentNode)) continue;
            res.add(((ComponentNode)obj).getName());
        }
        return res;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getKey() {
        return this.key;
    }

    public ArrayList<T> getChildren() {
        return this.children;
    }

    public void addChild(T child) throws NullPointerException {
        if (((ComponentNode)child).parent == null) {
            if (((ComponentNode)child).nodeDict != null && ((ComponentNode)child).nodeDict != this.nodeDict) {
                this.nodeDict.putAll(((ComponentNode)child).getNodeDict());
                ((ComponentNode)child).nodeDict = this.nodeDict;
            } else {
                ((ComponentNode)child).setDict(this.nodeDict, ((ComponentNode)child).getName(), ((ComponentNode)child).getAttributes());
            }
        } else if (((ComponentNode)child).parent != this) {
            throw new IllegalArgumentException("child added but is part of another node tree");
        }
        this.children.add(child);
    }

    public String toString() {
        String valueString;
        try {
            valueString = String.valueOf(this.realValue);
        }
        catch (Exception exc) {
            valueString = "can't trace value [" + exc + "] ";
        }
        return String.valueOf(String.valueOf(this.name)) + "(" + valueString + "," + String.valueOf(this.attributes) + ") {" + String.valueOf(this.children) + "}";
    }

    public T getParent() {
        return this.parent;
    }

    public <V> void proceduralWalk(Class<V> klass, Consumer<V> pre, Consumer<V> post) {
        Z component;
        if (pre != null && klass.isAssignableFrom((component = this.getRealValue()).getClass())) {
            pre.accept(component);
        }
        for (ComponentNode child : this.getChildren()) {
            child.proceduralWalk(klass, pre, post);
        }
        if (post != null && klass.isAssignableFrom((component = this.getRealValue()).getClass())) {
            post.accept(component);
        }
    }

    public void proceduralNodeWalk(Consumer<T> pre, Consumer<T> post) {
        if (pre != null) {
            pre.accept(this);
        }
        for (ComponentNode child : this.getChildren()) {
            child.proceduralNodeWalk(pre, post);
        }
        if (post != null) {
            post.accept(this);
        }
    }

    public <V> TreeWalkerDiag treeWalk(Class<V> klass, Function<V, TreeWalkerDiag> func, Consumer<V> post) {
        Z component;
        TreeWalkerDiag diag = TreeWalkerDiag.GO;
        if (func != null && klass.isAssignableFrom((component = this.getRealValue()).getClass())) {
            diag = func.apply(component);
        }
        switch (diag) {
            case STOP: {
                return diag;
            }
            case HANDLING_CHILDREN: {
                return diag;
            }
        }
        for (ComponentNode child : this.getChildren()) {
            TreeWalkerDiag childRes = child.treeWalk(klass, func, post);
            if (!childRes.equals((Object)TreeWalkerDiag.STOP)) continue;
            return childRes;
        }
        if (post != null && klass.isAssignableFrom((component = this.getRealValue()).getClass())) {
            post.accept(this);
        }
        return diag;
    }

    static class IndirectHash<K, V>
    extends LinkedHashMap<K, V>
    implements IndirectMap<K, V> {
        IndirectHash() {
        }

        @Override
        public Object getIndirect(Object key) {
            Object obj = this.get(key);
            if (obj instanceof ComponentNode) {
                obj = ((ComponentNode)obj).getRealValue();
            }
            Tracer.trace(Tracer.NODE_BUILD, "reference to ", key, " ", obj);
            if (obj == null) {
                logger.log(Level.WARNING, "null reference associated to {0}", key);
            }
            return obj;
        }
    }
}

