/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.groovy.description;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.gruth.jutils.Constraints;

public class ConstraintsTest {
    @Test
    public void testMapConstraints() {
        Object res = Constraints.check((String)"java.util.Map", (String)"[min:10,max:89]", null);
        Assert.assertTrue((boolean)(res instanceof Map));
        Map resMap = (Map)res;
        Assert.assertEquals((long)2L, (long)resMap.size());
        Assert.assertEquals((long)10L, (long)((Integer)resMap.get("min")).intValue());
        Assert.assertEquals((long)89L, (long)((Integer)resMap.get("max")).intValue());
        res = Constraints.check((String)"java.util.Map", (String)"[min:10,max:89]", (String)"##val##(val.get('min')>=8)&&(val.get('max') >= 89)");
        Assert.assertTrue((boolean)(res instanceof Map));
        resMap = (Map)res;
        Assert.assertEquals((long)2L, (long)resMap.size());
        Assert.assertEquals((long)10L, (long)((Integer)resMap.get("min")).intValue());
        Assert.assertEquals((long)89L, (long)((Integer)resMap.get("max")).intValue());
    }

    @Test
    public void testRange() {
        Object o = Constraints.check((String)"java.lang.Integer", (String)"50", (String)"0..100");
        Assert.assertTrue(((Integer)o == 50 ? 1 : 0) != 0);
        try {
            Constraints.check((String)"java.lang.Integer", (String)"-50", (String)"0..100");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        o = Constraints.check((String)"java.lang.Double", (String)"50.0", (String)"0.0..100.0");
        Assert.assertTrue(((Double)o == 50.0 ? 1 : 0) != 0);
        o = Constraints.check((String)"java.lang.Double", (String)"50.", (String)"50.0..100.0");
        Assert.assertTrue(((Double)o == 50.0 ? 1 : 0) != 0);
        o = Constraints.check((String)"java.lang.Character", (String)"B", (String)"A..C");
        Assert.assertTrue((boolean)"B".equals((String)o));
        o = Constraints.check((String)"java.lang.String", (String)"abc", (String)"aaa..ccc");
        Assert.assertTrue((boolean)"abc".equals((String)o));
    }

    @Test
    public void testArray() {
        String arrayString = "[1,2,3,4,5]";
        Object res = Constraints.buildObject((String)"[I", (String)arrayString);
        System.out.println(res.getClass());
    }
}

