package org.lsst.gruth.jutils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 
 * @author The LSST CCS Team
 */
// Date: 04/09/13

public class TypeUtils {
    public static String stringify(Object obj){
        String res ;
        if(obj instanceof BigDecimal) {
            res = ((BigDecimal)obj).toPlainString() ;
        } else if (obj instanceof Map) {
            // Dos not work properly : res= DefaultGroovyMethods.toMapString((Map) obj);
            res= toMapString((Map) obj);
        } else if (obj instanceof List) {
            // does not work properly : res= DefaultGroovyMethods.toListString((List) obj);
            res= toListString((List) obj);
        } else if(obj.getClass().isArray()) {
            res =  toArrayString(obj) ;
        }
        else {
            res = String.valueOf(obj) ;
        }
        return res ;

    }

    private static String  toArrayString(Object obj){
        StringBuilder builder = new StringBuilder("[");
        int size = Array.getLength(obj) ;
        for(int ix = 0 ; ix < size ; ix++) {
            Object item = Array.get(obj, ix);
            if(item instanceof String) {
                builder.append("'").append(item).append("'") ;
            } else {
                builder.append(stringify(item)) ;
            }

            if(ix < (size -1)) {
                builder.append(",");
            }
        }
        builder.append("]") ;
        return builder.toString();
    }
    //TODO : Double and Float string changed to "as double" "as Float" ?
    // rationale: this is of no importance for constuctors
    // but will probably need a distinct behaviour when we use "raw" lists
    private static String  toListString(List list){
        StringBuilder builder = new StringBuilder("[");
        int size = list.size();
        for(int ix = 0 ; ix < size ; ix++) {
            Object item = list.get(ix);
            if(item instanceof String) {
                builder.append("'").append(item).append("'") ;
            } else {
                builder.append(stringify(item)) ;
            }

            if(ix < (size -1)) {
                builder.append(",");
            }
        }
        builder.append("]") ;
        return builder.toString();
    }
    //TODO :change double and floats values as for List?
    // rationale: this is of no importance for constuctors
    // but will probably need a distinct behaviour when we use "raw" lists
    private static String  toMapString(Map map){
        StringBuilder builder = new StringBuilder("[");
        Set<Map.Entry> entries = map.entrySet() ;
        int size =entries.size() ;
        int ix = 0 ;
        for(Map.Entry entry : entries) {
            builder.append(entry.getKey()).append(":") ;
            Object item = entry.getValue() ;
            if(item instanceof String) {
                builder.append("'").append(item).append("'") ;
            } else {
                builder.append(stringify(item)) ;
            }
            if(ix < (size -1)) {
                builder.append(",");
            }
            ix++ ;
        }
        builder.append("]") ;
        return builder.toString();
    }
}