package org.lsst.gruth.jutils;


import org.lsst.ccs.description.IndirectMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author bamade
 */
public class BuiltParm implements Serializable{
    public enum Type { ARRAY, LIST, MAP, SET} ;
    //TODO: cyclic dependency with MapArgs!
    //TODO: harmonize with HollowParm by creating appropriate org.lsst.gruth.types
    private MapArgs args ;
    private final Type type ;

    public BuiltParm(Type type, MapArgs args) {
        this.args = args;
        this.type = type;
    }

    public MapArgs getArgs() {
        return args;
    }

    public Type getType() {
        return type;
    }

    public static BuiltParm bldArray(MapArgs.LEntry... entries) {
        BuiltParm res = new BuiltParm(Type.ARRAY,  MapArgs.argMap(entries)) ;
        return res ;
    }
    public static BuiltParm bldArray(Object... obj) {
        BuiltParm res = new BuiltParm(Type.ARRAY,  MapArgs.argList(obj)) ;
        return res ;
    }
    //TODO ??????
    public static BuiltParm bldArray(Map<?,?> map, Object... obj) {
        BuiltParm res = new BuiltParm(Type.ARRAY,  MapArgs.argList(obj)) ;
        return res ;
    }
    public static BuiltParm bldList(MapArgs.LEntry... entries) {
        BuiltParm res = new BuiltParm(Type.LIST,  MapArgs.argMap(entries)) ;
        return res ;
    }
    public static BuiltParm bldList(Object... obj) {
        BuiltParm res = new BuiltParm(Type.LIST,  MapArgs.argList(obj)) ;
        return res ;
    }
    public static BuiltParm bldMap(MapArgs.LEntry... entries) {
        BuiltParm res = new BuiltParm(Type.MAP,  MapArgs.argMap(entries)) ;
        return res ;
    }

    public boolean isSafe() {
        return args.isSafe() ;
    }
    public boolean isValuesOnly() {
        return args.isValuesOnly() ;
    }

    public Object fullValue(IndirectMap<String,Object> objectDictionary ){
        switch(type){
            case ARRAY: return args.asFullArray(objectDictionary) ;
            case LIST: return args.asFullList(objectDictionary) ;
            case MAP: case SET :
                return args.asFullMap(objectDictionary) ;
        }
        throw new Error(" BuiltParm type: should not happen");
    }

    public void overlap(boolean acceptNullvalues , Object[] array) {
        args = args.overlap(acceptNullvalues, array) ;
    }
    public void overlap(boolean acceptNullvalues , List<Object> list) {
        args = args.overlap(acceptNullvalues, list) ;
    }
    public void overlap(boolean acceptNullvalues , MapArgs map) {
        args = args.overlap(acceptNullvalues, map) ;
    }

    public String toString() {
        return String.valueOf(args) ;
    }

}
