package org.lsst.gruth.jutils;


import org.lsst.gruth.types.IncompatibleTypeException;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * @author bamade
 */
public class BoolParm  extends HollowParm<Boolean>{

    public BoolParm() {
        super(Boolean.FALSE);
    }

    public BoolParm(Boolean value) {
        super(value) ;
    }

    public BoolParm(String strBool) {
        this(Boolean.valueOf(strBool)) ;
    }

    public BoolParm(Boolean value, Map<?,?> map) {
        super(value, map) ;
    }

    public BoolParm(String strBool,Map<?,?> map) {
        this(Boolean.valueOf(strBool), map) ;
    }

    public void setValue(String strBool) {
        this.setValue(Boolean.valueOf(strBool));
    }

    @Override
    public void setNullValue(){
        this.setValue(Boolean.FALSE);
    }

    @Override
    public void clear() {
        this.setValue(Boolean.FALSE);
    }

    //TODO: mutualize this method acrass all classes that have different setValue
     public void modifyChecked(Object obj) {
          if(readOnly) return ;
        if(obj == null) {
            setNullValue();
            return ;
        }
        Class clazz = obj.getClass() ;
          Class myClass = this.getClass() ;

          try {
              Method method = myClass.getDeclaredMethod("setValue", clazz) ;
              method.invoke(this,obj) ;
          } catch (Exception e) {
              throw new IncompatibleTypeException(myClass, clazz) ;
          }
    }
    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class ;
    }
}
