package org.lsst.ccs.description;

import java.io.BufferedInputStream;
import java.io.IOException;

import java.io.InputStream;
import java.io.ObjectInputStream;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 * The ComponentNodeFactory for Serialized objects.
 *
 * The LSST CCS Team.
 */
class SerializedComponentNodeFactory implements ComponentNodeBuilder.ComponentNodeFactory {

    @Override
    public DescriptiveNode buildDescriptiveNode(String descriptionStr) {
        descriptionStr += ".ser";        
        Exception ex = null;
        try {
            InputStream is = BootstrapResourceUtils.getBootstrapResource(descriptionStr, SerializedComponentNodeFactory.class);
            if (is != null) {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
                return (DescriptiveNode) ois.readObject();
            }
        } catch (ClassNotFoundException | IOException e) {
            ex = e;
        }
        throw new RuntimeException("Could not build DescriptiveNode for " + descriptionStr, ex);
    }
    
    @Override
    public String getProtocol() {
        return "ser";
    }

}
