/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.groovy.ComponentBuilder;
import org.lsst.ccs.utilities.logging.Logger;

public class ComponentNodeFactory
implements ComponentNodeBuilder.ComponentNodeFactory {
    @Override
    public DescriptiveNode buildDescriptiveNode(String descriptionStr) {
        InputStream is;
        if (descriptionStr.contains("/")) {
            throw new IllegalArgumentException("description files must be located at the root of a resource directory");
        }
        if (descriptionStr.endsWith(".groovy")) {
            Logger.getLogger((String)"org.lsst.ccs.description.groovy").warn((Object)"Description file extension has to be skipped in the --description argument");
        }
        if (!descriptionStr.endsWith(".groovy")) {
            descriptionStr = String.valueOf(descriptionStr) + ".groovy";
        }
        if ((is = BootstrapResourceUtils.getBootstrapResource((String)descriptionStr, ComponentNodeFactory.class)) == null) {
            throw new IllegalArgumentException("Could not find resource for " + descriptionStr);
        }
        try {
            GroovyShell shell = ComponentNodeFactory.shellFactory();
            InputStreamReader reader = new InputStreamReader(is, "ISO-8859-1");
            Object res = shell.evaluate((Reader)reader);
            if (!(res instanceof DescriptiveNode)) {
                throw new IllegalArgumentException("The described object is not a DescriptiveNode: " + res.getClass());
            }
            DescriptiveNode node = (DescriptiveNode)res;
            node.setProtocol(this.getProtocol());
            return node;
        }
        catch (UnsupportedEncodingException | IllegalArgumentException | CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getProtocol() {
        return "groovy";
    }

    static GroovyShell shellFactory() {
        Binding binding = new Binding();
        ComponentBuilder builder = new ComponentBuilder();
        binding.setProperty("builder", (Object)builder);
        GroovyShell shell = new GroovyShell(binding);
        return shell;
    }
}

