package org.lsst.gruth.jutils;

import groovy.util.Eval;
import org.lsst.gruth.types.GStruct;
import org.lsst.gruth.types.IncompatibleTypeException;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author bamade
 */
// Date: 11/10/12

public class SStructParm extends HollowParm {
    private Class actualClass ;
    private boolean usesList ;
    static Map<Class, Boolean> usesRealConstructor = new HashMap<Class, Boolean>() ;

    public static Boolean structClassUsesList(Class clazz) {
       return usesRealConstructor.get(clazz) ;
    }

    @Override
    public Class getValueClass() {
        return actualClass;
    }

    public SStructParm(Class clazz, List values) {
        super((Serializable)GStruct.valueOf(clazz, values)) ;
        this.actualClass = clazz ;
        usesRealConstructor.put(clazz, true) ;
        usesList = true ;
    }
    public SStructParm(Class clazz, List values, Map properties) {
        super((Serializable)GStruct.valueOf(clazz, values), properties) ;
        this.actualClass = clazz ;
        usesRealConstructor.put(clazz, true) ;
        usesList = true ;
    }

    public SStructParm(Class clazz, Map values) {
        super((Serializable)GStruct.valueOf(clazz, values)) ;
        this.actualClass = clazz ;
        usesRealConstructor.put(clazz, false) ;
        usesList = false ;
    }
    public SStructParm(Class clazz, Map values, Map properties) {
        super((Serializable)GStruct.valueOf(clazz, values), properties) ;
        this.actualClass = clazz ;
        usesRealConstructor.put(clazz, false) ;
        usesList = false ;
    }

    public void setValue(Serializable arg) {
        if(actualClass.isAssignableFrom(arg.getClass())) {
            super.setValue(arg);
        } else {
            throw new IncompatibleTypeException(actualClass, arg.getClass()) ;
        }
    }

    public void setValue(String strVal) {
        modifyChecked(strVal);
    }

    public void setValue(Map map) {
        modifyChecked(map);
    }

    public void setValue(List list) {
        modifyChecked(list);
    }

    @Override
    public void modifyChecked(Object obj){

        if (readOnly) return ;
        if(obj == null) {
            setNullValue();
            return ;
        }

        if(obj instanceof String){
            obj = Eval.me((String) obj) ;
        }

        if (obj instanceof  Map ) {
            if(usesList) {
                throw new IllegalArgumentException( actualClass +
                " uses only list as parameter") ;
            }
             setValue((Serializable) GStruct.valueOf(actualClass, (Map) obj)) ;
        } else if (obj instanceof List) {
            if(! usesList) {
                throw new IllegalArgumentException( actualClass +
                        " uses only map as parameter") ;
            }
            setValue((Serializable) GStruct.valueOf(actualClass, (List)obj)) ;

        } else {
            setValue((Serializable)obj);
        }
    }

    //TODO serialisation is important otherwise data in map not maintained
    private void writeObject(java.io.ObjectOutputStream out)
            throws IOException {
        out.defaultWriteObject();

    }
    private void readObject(java.io.ObjectInputStream in)
            throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class clazz = this.actualClass ;
        if(null == structClassUsesList(clazz)) {
            usesRealConstructor.put(clazz, usesList) ;
        }

    }
}
