package org.lsst.gruth.jutils;

import org.lsst.gruth.types.GList;
import org.lsst.gruth.types.GMap;
import org.lsst.gruth.types.IncompatibleTypeException;

import java.util.Map;

/**
 * @author bamade
 */
// Date: 01/10/12

public class MapParm  extends HollowParm<GMap>{
    public MapParm() {
        super() ;
    }

    public MapParm(Map map) {
        super(new GMap(map)) ;
    }
    public MapParm(Map map, Map<?,?> props) {
        super(new GMap(map), props) ;
    }

    public MapParm(String strVal) {
        super(GMap.valueOf(strVal)) ;
    }
    public MapParm(String strVal, Map<?,?> props) {
        super(GMap.valueOf(strVal), props) ;
    }

    public void setValue(String valStr) {
        if(readOnly) return ;
        super.setValue(GMap.valueOf(valStr));
    }
    public void setValue(Map map) {
        if(readOnly) return ;
        super.setValue(new GMap(map));
    }

    @Override
    public Class<GMap> getValueClass() {
        return GMap.class;
    }
    public void modifyChecked(Object obj) {
        if(readOnly) return ;
        if (obj == null) {
            setNullValue();
            return;
        }
        Class clazz = obj.getClass();
        if(String.class.equals(clazz)) {
            setValue((String) obj);
        } else if (Map.class.isAssignableFrom(clazz)) {
            setValue((Map) obj);
        }  else {
            throw new IncompatibleTypeException(GList.class, clazz);
        }
    }
}
