package org.lsst.gruth.jutils;

import org.lsst.gruth.types.GList;
import org.lsst.gruth.types.IncompatibleTypeException;

import java.util.Collection;
import java.util.Map;

/**
 * can hold  a list of values (cannot be used with a list of HollowParm)
 * @author bamade
 */
// Date: 01/10/12

public class ListParm  extends HollowParm<GList>{
    public ListParm() {
        super() ;
    }

    public ListParm(Collection col) {
        super(new GList(col)) ;
    }
    public ListParm(Collection col, Map<?,?> props) {
        super(new GList(col), props) ;
    }

    public ListParm(String strVal) {
        super(GList.valueOf(strVal)) ;
    }
    public ListParm(String strVal, Map<?,?> props) {
        super(GList.valueOf(strVal), props) ;
    }

    public void setValue(String valStr) {
        if(readOnly) return ;
        super.setValue(GList.valueOf(valStr));
    }
    public void setValue(Collection col) {
        if(readOnly) return ;
        super.setValue(new GList(col));
    }

    public void setValue(Object... vals) {
        if(readOnly) return ;
        super.setValue(new GList(vals));
    }
    @Override
    public Class<GList> getValueClass() {
        return GList.class;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void modifyChecked(Object obj) {
        if(readOnly) return ;
        if (obj == null) {
            setNullValue();
            return;
        }
        Class clazz = obj.getClass();
        if(String.class.equals(clazz)) {
            setValue((String) obj);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            setValue((Collection) obj);
        } else if (clazz.isArray()) {
            setValue((Object[])obj);
        } else {
            throw new IncompatibleTypeException(GList.class, clazz);
        }
    }
}
