package org.lsst.ccs.description.groovy;

import groovy.util.BuilderSupport;

import java.util.Map;
import org.lsst.ccs.description.DescriptiveNode;

/**
 * Class dedicated to building nodes from a groovy description file.
 * All it does is build DescriptiveNodes from the provided arguments.
 * It also sets the parent/child relationship as the tree is built.
 *
 * This class is overwritten by CCSBuilder in the startup package.
 * CCSBuilder is used directly in the groovy files.
 *
 * @author The LSST CCS Team
 */
public class ComponentBuilder extends BuilderSupport {

    @Override
    public void setParent(Object o, Object o1) {
        DescriptiveNode parent = (DescriptiveNode) o;
        parent.addChild((DescriptiveNode) o1);
    }

    @Override
    @Deprecated
    public Object createNode(Object name) {
        System.out.println("******** Deprecated method! Why is this being used? "+name);
        return new DescriptiveNode(getCurrentNode(), (String)name);
    }

    @Override
    public Object createNode(Object name, Object value) {
        return new DescriptiveNode(getCurrentNode(), (String)name, (Class)value);
    }

    @Override
    @Deprecated
    public Object createNode(Object name, Map attributes) {
        System.out.println("******** Deprecated method! Why is this being used? "+name+" "+attributes);
        return new DescriptiveNode(getCurrentNode(), (String)name, attributes);
    }

    @Override
    public Object createNode(Object name, Map attributes, Object value) {
        return new DescriptiveNode(getCurrentNode(), (String)name, attributes, (Class)value);
    }

    protected DescriptiveNode getCurrentNode() {
        DescriptiveNode current = (DescriptiveNode) getCurrent();
        return current;
    }
    
}
