package org.lsst.ccs.description;

import org.apache.commons.beanutils.MethodUtils;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
/**
 * @author bamade
 */
class MethodsCalls {
    public static Object invokeMethod(Object object, String methodName, Object... args) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
            //TODO: implements  more robust algorithm (see groovy's MetaClassImpl.chooseMethodInternal)
            //TODO: implement a cache
            //TODO :check if new version of MethodUtils work with varargs?
            /*

               workaround for varargs methods
                - check all methods for the class
                - pick one with the name
                - if varargs
                     get the args in the last argument
                     use Arrays.copyOf to generate correct
                   else
                   standard methodUtils
             */
            Class clazz = object.getClass() ;
            Method[] methods = clazz.getMethods() ;
            boolean found = false ;
            for(Method method : methods) {
                if(method.getName().equals(methodName)) {
                    found = true ;
                    if(method.isVarArgs()) {
                        int nbArgs = args.length ;
                        Class[] argsType = method.getParameterTypes() ;
                        //System.out.println("Classes: " + Arrays.toString(argsType));
                        int nbRequestedArgs = argsType.length ;
                        Class arrayType = argsType[nbRequestedArgs-1] ;
                        Object[] newArgs ;
                        if(nbRequestedArgs == 1 ){
                           //newArgs = Arrays.copyOf(args, args.length, arrayType);
                            newArgs = new Object[1] ;
                            //System.out.println("requested :" +arrayType + "actual" + args[0].getClass());
                            //Tracer.trace(Tracer.NODE_CALLS, "requested :" +arrayType + "actual" + args[0].getClass());
			    // bizarre bug!
                            Tracer.trace(Tracer.NODE_CALLS, new Object[] {"requested :" +arrayType + "actual" + args[0].getClass()});
                            newArgs[0] = Arrays.copyOf(args, args.length, arrayType);
                        } else {
                            newArgs = new Object[nbRequestedArgs] ;
                            int lastIndex = nbRequestedArgs-1 ;
                            for(int ix=0 ;ix < lastIndex; ix++){
                                if(ix >= nbArgs){
                                    throw new IllegalArgumentException("varArgs confusion: waiting for " + nbArgs +
                                    "arguments") ;
                                }
                                newArgs[ix] = args[ix] ;
                            }
                            // if empty
                            if(nbArgs== lastIndex) {
                                newArgs[lastIndex] = Array.newInstance(arrayType.getComponentType(),0) ;
                                //System.out.println("array:" + Arrays.toString(newArgs));
                                //System.out.println("req type" + arrayType + "real type" + newArgs[lastIndex].getClass());
                            } else {
                                int diff = nbArgs - nbRequestedArgs +1;
                                //System.out.println(" diff:" + diff + " nbArgs" + nbArgs + " requested" + nbRequestedArgs);
                                newArgs[lastIndex] = Array.newInstance(arrayType.getComponentType(),diff) ;
                                Object[] realArray = (Object[]) newArgs[lastIndex] ;
                                for(int ix = 0; ix <diff ; ix++) {
                                    realArray[ix] = args[lastIndex + ix] ;
                                }

                            }

                        }
                        return method.invoke(object, newArgs) ;
                        //return MethodUtils.invokeMethod(object, methodName, newArgs) ;

                    } else {
                        break ;
                    }
                }
            }

            return MethodUtils.invokeMethod(object, methodName, args) ;

    }
}
