package org.lsst.ccs.description;

import java.util.Map;
import org.lsst.gruth.jutils.MapArgs;

/**
 * A Subsystem DescriptiveNode contains all the needed information to build
 * an EffectiveNode.
 * A DescriptiveNode contains the class name of the object to be created on this
 * node and all the attributes needed to build it.
 * 
 */
public class DescriptiveNode extends ComponentNode<DescriptiveNode,Class> implements Cloneable{

    private String subsystemName, protocol;    
    
    @Deprecated
    public DescriptiveNode(DescriptiveNode parent, String name) {
        super(parent, name);
    }

    public DescriptiveNode(DescriptiveNode parent, String name, Class value) {
        super(parent, name, value);
    }

    @Deprecated
    public DescriptiveNode(DescriptiveNode parent, String name, Map attributes) {
        super(parent, name, attributes);
    }

    public DescriptiveNode(DescriptiveNode parent, String name, Map attributes, Class value) {
        super(parent, name, attributes, value);
    }

    public DescriptiveNode clone() {
        Map newAttributes = attributes;
        if (attributes instanceof MapArgs) {
            newAttributes = ((MapArgs) attributes).clone();
        }
        DescriptiveNode res = new DescriptiveNode((DescriptiveNode) null, name, newAttributes, realValue) ;

        if (children != null) {
            for (DescriptiveNode child : children) {
                DescriptiveNode newChild = child.clone();
                newChild.parent = null;
                res.addChild(newChild);
            }
        }

        return  res;
    }

    public String getSubsystemName() {
        return subsystemName;
    }
    public void setSubsystemName(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    public String getProtocol() {
        return protocol;
    }
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}
