/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.nodes;

import groovy.util.IndentPrinter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.MapArgs;

public class ComponentTreePrinter {
    protected final IndentPrinter out;

    public ComponentTreePrinter() {
        this(new IndentPrinter((Writer)new PrintWriter(new OutputStreamWriter(System.out))));
    }

    public ComponentTreePrinter(PrintWriter out) {
        this(new IndentPrinter((Writer)out));
    }

    public ComponentTreePrinter(IndentPrinter out) {
        if (out == null) {
            throw new NullPointerException(" 'out' must not be null!");
        }
        this.out = out;
    }

    public void print(ComponentNode node) {
        ComponentNode calls;
        boolean hasAttributes;
        this.out.printIndent();
        this.printName(node);
        Object value = node.getRealValue();
        boolean hasValue = value != null;
        this.out.print(" ( ");
        this.out.print(String.valueOf(value));
        Map attributes = node.getAttributes();
        boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            this.printAttributes(hasValue, attributes);
        }
        this.out.println(")");
        ArrayList list = node.getChildren();
        if (list != null && list.size() != 0) {
            this.printList(list);
        }
        if ((calls = node.getCalls()) != null) {
            this.print(calls);
        }
        this.out.flush();
    }

    protected void printName(ComponentNode node) {
        String name = node.getName();
        if (name != null) {
            this.out.print("\"" + name.toString() + "\"");
        } else {
            this.out.print("null");
        }
    }

    protected void printList(List list) {
        if (list.isEmpty()) {
            this.out.println();
        } else {
            this.out.incrementIndent();
            this.out.printIndent();
            this.out.println(" {");
            this.out.incrementIndent();
            for (Object value : list) {
                if (!(value instanceof ComponentNode)) continue;
                this.print((ComponentNode)value);
                this.out.println();
            }
            this.out.decrementIndent();
            this.out.printIndent();
            this.out.println("}");
            this.out.decrementIndent();
        }
    }

    protected void printAttributes(boolean hasValue, Map attributes) {
        if (attributes instanceof MapArgs) {
            MapArgs real = (MapArgs)attributes;
            this.out.print(real.toString());
        } else {
            this.printMapAttributes(hasValue, attributes);
        }
    }

    protected void printMapAttributes(boolean hasValue, Map attributes) {
        this.out.print(", argMap(");
        boolean first = true;
        for (Map.Entry entry : attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.out.print(", ");
            }
            this.out.print("\"" + entry.getKey().toString() + "\"");
            this.out.print(":");
            if (entry.getValue() instanceof String) {
                this.out.print("'" + entry.getValue() + "'");
                continue;
            }
            this.out.print(InvokerHelper.toString(entry.getValue()));
        }
        this.out.print(" )");
    }
}

