/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import groovy.util.Eval;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.gruth.jutils.SStructParm;
import org.lsst.gruth.types.GArray;
import org.lsst.gruth.types.GStruct;
import org.lsst.gruth.types.IncompatibleTypeException;

public class Constraints {
    private Constraints() {
    }

    public static Object check(String type, String value, String constraints) {
        type = type.trim();
        value = value.trim();
        Object realValue = Constraints.buildObject(type, value);
        if (constraints == null) {
            return realValue;
        }
        if ("".equals(constraints = constraints.trim())) {
            return realValue;
        }
        String[] split = constraints.split("\\.\\.");
        if (split.length == 2) {
            return Constraints.checkRange(realValue.getClass(), value, split[0], split[1]);
        }
        try {
            if (constraints.startsWith("##")) {
                boolean doIt;
                String expr;
                String[] splits = constraints.split("##");
                String argName = splits[1];
                Object checks = Eval.me((String)argName, (Object)realValue, (String)(expr = splits[2]));
                if (checks instanceof Boolean && (doIt = ((Boolean)checks).booleanValue())) {
                    return realValue;
                }
                throw new IllegalArgumentException(" predicate " + expr + " FAILED");
            }
            Controler controler = (Controler)Class.forName(constraints).newInstance();
            return Constraints.checkWithControler(value, controler);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("constraint :" + constraints + " " + exc);
        }
    }

    public static Object buildObject(String type, String value) {
        Object realValue = null;
        Class<?> thatClass = null;
        try {
            if ("java.lang.Character".equals(type)) {
                type = "java.lang.String";
            }
            realValue = (thatClass = Class.forName(type)).isArray() ? GArray.valueOf(value, thatClass.getName()) : (SStructParm.structClassUsesList(thatClass) != null ? GStruct.valueOf(thatClass, value) : MethodUtils.invokeStaticMethod(thatClass, (String)"valueOf", (Object)value));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            if (Map.class.isAssignableFrom(thatClass) || List.class.isAssignableFrom(thatClass)) {
                try {
                    realValue = Eval.me((String)value);
                }
                catch (Exception exc) {
                    throw new IllegalArgumentException(exc);
                }
                Class<?> realClass = realValue.getClass();
                if (!thatClass.isAssignableFrom(realClass)) {
                    throw new IncompatibleTypeException(thatClass, realClass);
                }
            }
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception exception) {
            return null;
        }
        return realValue;
    }

    private static Object checkRange(Class thatClass, String value, String lower, String upper) {
        Object realValue = null;
        try {
            realValue = MethodUtils.invokeStaticMethod((Class)thatClass, (String)"valueOf", (Object)value);
            Object realUpper = MethodUtils.invokeStaticMethod((Class)thatClass, (String)"valueOf", (Object)upper);
            Object realLower = MethodUtils.invokeStaticMethod((Class)thatClass, (String)"valueOf", (Object)lower);
            Comparable compValue = (Comparable)realValue;
            if (compValue.compareTo(realLower) >= 0 && compValue.compareTo(realUpper) <= 0) {
                return realValue;
            }
            throw new IllegalArgumentException(realValue + "not in range [" + realLower + ".." + realUpper + "]");
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("range " + lower + ".." + upper + " and value :" + value + " raises :" + exc);
        }
    }

    private static Object checkWithControler(String value, Controler controler) {
        return controler.control(value);
    }

    public static interface Controler {
        public Object control(String var1);
    }
}

