package org.lsst.gruth.nodes;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import org.lsst.gruth.jutils.DescriptiveNode;

import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @author bamade
 */
// Date: 04/06/12

public class Utils {
    
    private Utils() {
    }
    
    /**
     * Generates a Component node from a simple script.
     * The ComponentBuilder is named <TT>builder</TT> and is provided in the Binding.
     * @param inputStream
     * @param encoding specifies the text encoding
     * @return a {@code DescriptiveNode} depicting the tree structure of the input file.
     * @throws Exception
     */
    public static DescriptiveNode getComponentNodeFromGroovy(InputStream inputStream, String encoding) throws Exception{
        GroovyShell shell = shellFactory() ;
        InputStreamReader reader = new InputStreamReader(inputStream,encoding) ;
        Object res = shell.evaluate(reader) ;
        if(! (res instanceof DescriptiveNode)) {
            throw new IllegalArgumentException(" described object not a ComponentNode but " +res.getClass());
        }
        return (DescriptiveNode) res;
    }

    static GroovyShell shellFactory() {
        //todo: add other variables in the Binding context?
        Binding binding = new Binding() ;
        // just says you have a variable that points to a ComponentBuilder
        // useless right now
        ComponentBuilder builder = new ComponentBuilder() ;
        binding.setProperty("builder", builder) ;
       // ClassLoader loader = Thread.currentThread().getContextClassLoader();
        //GroovyClassLoader groovyLoader = new GroovyClassLoader(loader) ;
        //GroovyShell shell = new GroovyShell(groovyLoader, binding) ;
        GroovyShell shell = new GroovyShell(binding) ;
       return shell ;
    }

    public static DescriptiveNode getComponentNodeFromGroovy(String scriptString) {
        GroovyShell shell = shellFactory() ;
        Object res = shell.evaluate(scriptString) ;
        if(! (res instanceof DescriptiveNode)) {
            throw new IllegalArgumentException("described object not a ComponentNode but " +res.getClass());
        }
        return (DescriptiveNode) res;

    }
}
