package org.lsst.gruth.jutils;

import org.apache.commons.beanutils.MethodUtils;
import org.lsst.gruth.types.IncompatibleTypeException;

import java.io.Serializable;
import java.util.Map;

/**
 * a utility to use parameter definition for
 * any object that has :
 * <UL>
 *     <LI/> <TT>Serializable</TT> implementation
 *     <LI/> a symmetric way of dealing with strings:
 *     the <TT>toString()</TT> method returns a String that
 *     can be used to create an Object through static method
 *     <TT>valueOf(thatString)</TT>
 * </UL>
 * A typical example are <TT>Enums</TT>
 * @author bamade
 */
// Date: 22/11/12

public class ValParm extends HollowParm{
    private Class actualClass ;
    @Override
    public Class<? extends Serializable> getValueClass() {
        return actualClass;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public ValParm(Serializable object) {
        super(object);
        this.actualClass = object.getClass() ;
    }

    public ValParm(Serializable object, Map<?,?> properties) {
        super(object, properties);
        this.actualClass = object.getClass() ;
    }
    public void setValue(Serializable arg) {
        if(actualClass.isAssignableFrom(arg.getClass())) {
            super.setValue(arg);
            //TODO : potential problem here if the subclass has different valueOF method!!!
        } else {
            throw new IncompatibleTypeException(actualClass, arg.getClass()) ;
        }
    }

    public void setValue(String strVal) {
        modifyChecked(strVal);
    }

    public void setValue(Object obj) {
        if(obj instanceof  String) {
            setValue((String)obj);
        } else if(obj instanceof Serializable) {
            setValue((Serializable) obj);
        } else {
            throw new IncompatibleTypeException("not serializable !", actualClass, obj.getClass()) ;
        }
    }

    @Override
    public void modifyChecked(Object obj){

        if (readOnly) return ;
        if(obj == null) {
            setNullValue();
            return ;
        }

        if(obj instanceof String){
            try {
                obj = MethodUtils.invokeStaticMethod(actualClass, "valueOf", (String)obj);
            } catch (Exception e) {
                throw new IncompatibleTypeException(e.toString(), actualClass, String.class);
            }
            ;
        }
        setValue(obj);
    }


}
