package org.lsst.gruth.jutils;

import org.lsst.gruth.utils.Tracer;

import java.io.Serializable;
import java.util.*;
import java.util.logging.Level;

/**
 * A node for a tree.
 * @param <T>
 * @ImplNote
 * There are two distinct ComponentNode: DescriptiveNodes (that contain component description)
 * and EffectiveNodes (that contains the actual object)
 *
 * @author bamade
 */
   // we cannot make it abstract dues to the fact that the "calls" node is used both by description and effective node (may be fix the calls node to a special different class)

public class ComponentNode <T extends ComponentNode<T>> implements Serializable {
    /**
     * this class supposes that the creation of the dictionary is made top down.
     * @param <K>
     * @param <V>
     */
    static class IndirectHash<K, V> extends LinkedHashMap<K, V> implements IndirectMap<K, V> {
        @Override
        public Object getIndirect(Object key) {
            Object obj = get(key);
            if (obj instanceof ComponentNode) {
                obj = ((ComponentNode) obj).getRealValue();
            }
            //Tracer.trace(Tracer.NODE_BUILD, "reference to ", key, " ", obj);
	    // bizarre bug!
            Tracer.trace(Tracer.NODE_BUILD, new Object[] {"reference to ", key, " ", obj});
            if (obj == null) {
                //TODO : fire error?
                PackCst._LOGGER.log(Level.WARNING, "null reference associated to {0}", key);
            }
            return obj;
        }
    }

    /**
     * A dictionary of all nodes in the tree. name duplications should be detected
     */
    protected /*@NotNull*/ IndirectMap<String, Object> nodeDict;
    /**
     * indicates if this is a root node
     */
    protected boolean root;
    /**
     * indicate if this node is waiting for connection to a tree.
     */
    protected boolean orphan;
    /**
     * a node containing special subnodes that describe method calls to be operated later on object value
     * (may be changed to a special structure)
     */
    //todo : move to a special node class and change CallBuilder
    protected /*Nullable*/ ComponentNode calls;
    /**
     * the key of the node
     */
    protected /*NotNull*/ String key;

    // standard NODE functions changed from Node
    protected T parent;
    protected ArrayList<T> children;

    /**
     * todo: righ now key and name should be the same .. if separate one must change the use of the dictionary
     *
     */
    protected String name;
    //TODO: suppress this field?
    protected String simpleDescription;


    /**
     * for DescriptiveNode the Class of the future object (or an ImplPlaceHolder)
     * for an EffectiveNode the actual object
     */
    protected Object realValue;
    /**
     * for a DescriptiveNode the description of parameters
     * not used for EffectiveNode (but might be with a copy of parameters description)
     */
    protected Map attributes;


    public IndirectMap getNodeDict() {
        return this.nodeDict;
    }

    @Deprecated
    public void setNodeDict(IndirectMap<String, Object> registry) {
        this.nodeDict = registry;
    }

    /**
     * prepare the setDict call
     * <B>Beware</B> should be used only in top-down build of the tree
     * @param parent
     * @param name
     * @param attributes
     */
    protected void checkDict(T parent, Object name, Map attributes) {
        IndirectMap<String, Object> dict;
        // todo check if not used by EffectiveNode
        if (parent == null) {
            dict = new IndirectHash<>();
            root = true;
        } else {
            dict = parent.getNodeDict();
        }
        setDict(dict, name, attributes);
    }

    /**
     * set the dictionary of the node and set the entry of this Node in the Dictionary
     * @param registry
     * @param name
     * @param attributes
     */
    //TODO change the semantics of key and name!
    protected void setDict(IndirectMap<String, Object> registry, Object name, Map attributes) {
        String keyStr = String.valueOf(name);
        /*  was feature supressed now a node can have two names
         reintroduced */
        if (attributes != null) {
            Object valName = attributes.get("name");
            if (valName != null) {
                keyStr = String.valueOf(valName);
            }
        } /**/
        this.key = keyStr;
        this.name = keyStr;
        /* modification suppressed
        //System.out.println("putting :" + key + " " + this.getRealValue());
        //registry.put(keyStr, this);
        // two names are possible now !!
        if (attributes != null) {
            Object valName = attributes.get("name");
            if (valName != null) {
                String realName = String.valueOf(valName);
                //this.name = keyStr ;
                this.name = realName.trim();
                //Todo: change that
                keyStr = realName ;
                System.out.println("NODE name " + realName);
            }
        }
        //TODO change that!! confusing
        // AVOID : will create pointer exception in AConfigProfile
        */
        registry.put(keyStr, this);
        /*suppresses
        if (this.name != null) {
            String altName = this.name.trim();
            if (!keyStr.equalsIgnoreCase(altName)) {
                //registry.put(altName, this);
            }
        }
        */
        this.nodeDict = registry;
    }


    public ComponentNode(T parent, Object name) {
        this(parent, name, (Map) null, null);
    }

    public ComponentNode(T parent, Object name, Object value) {
        this(parent, name, (Map) null, value);
    }

    public ComponentNode(T parent, Object name, Map attributes) {
        this(parent, name, attributes, null);
    }

    public ComponentNode(T parent, Object name, Map attributes, Object value) {
        this.parent = parent;
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        checkDict(parent, name, attributes);
        //TODO: why on earth does we need to suppres this?
        /*
        if(parent != null ) {
            ArrayList parentChilds = parent.children ;
            if(parentChilds == null ) {
                parentChilds = new ArrayList<ComponentNode>() ;
            }
            System.out.println("ctor adding " + this.getName() + " to " + parent.getName());
            //parentChilds.add(this) ;
        }
        */
    }

    /**
     * this constructor to be used by EffectiveNode (does not use checkDict!)
     * @param registry
     * @param name
     * @param key
     * @param attributes
     * @param value
     */
    protected ComponentNode(IndirectMap<String, Object> registry, Object name, String key, Map attributes, Object value) {
        this.simpleDescription = this.name = String.valueOf(name);
        this.attributes = attributes;
        this.realValue = value;
        //TODO: fix the ambigity between name and kay when building "orphan" this is a feature bug!
        //setDict(registry, key, attributes);
        setDict(registry, name, attributes);
        orphan = true;
    }


    /**
     * a ComponentNode might have a "calls" method which takes a Closure as parameter.
     * @param callDescription
     * @return
     */
    public Object calls(Object callDescription) {
        CallBuilders.CallBuilds builder = CallBuilders.getCallBuilder();
        //todo: change that! the cast is
        this.calls = builder.buildCalls(this, callDescription);
        return this;
    }

    public ComponentNode setCalls(ComponentNode callsNode) {
        this.calls = callsNode;
        return this;
    }

    public boolean isRoot() {
        return root;
    }

    public void setRoot(boolean isRoot) {
        root = isRoot;
    }

    public boolean isOrphan() {
        return orphan;
    }

    public ComponentNode getCalls() {
        return calls;
    }


    public String getName() {
        return name;
    }

    public String getSimpleDescription() {
        return simpleDescription;
    }

    public void setSimpleDescription(String simpleDescription) {
        this.simpleDescription = simpleDescription;
    }

    public Object getRealValue() {
        return realValue;
    }

    public Object getNodeByName(String name) {
        //System.out.println("keys" + nodeDict.keySet());
        return this.nodeDict.get(name);
    }

    public Object getIndirect(Object key) {
        Object node = this.nodeDict.get(key);
        if (node instanceof ComponentNode) {
            return ((ComponentNode) node).getRealValue();
        }
        return node;
    }

    public Iterator<String> getAllKeys() {
        return nodeDict.keySet().iterator();
    }

    public Iterable<String> getAllNames() {
        Collection<Object>col = nodeDict.values() ;
        HashSet<String> res = new HashSet<>() ;
        for(Object obj : col) {
            if(obj instanceof ComponentNode) {
               res.add(((ComponentNode)obj).getName())  ;
            }
        }
        return res ;
    }


    public Map getAttributes() {
        return attributes;
    }

    public String getKey() {
        return key;
    }


    /**
     * @return the list of child nodes, <TT>null</TT> if there aren't any
     */
    //todo: generalize the type of children
    public /*Nullable*/ ArrayList<T> getChildren() {
        return children;
    }

    /**
     * adds a ComponentNode as a child of the current node
     *
     * @param child to be added to the node
     * @throws NullPointerException if child is null
     */
    //todo: rewrite to distinguish the case of DescriptiveNode and EffectiveNode
    public  void    addChild(/*NotNull*/ T child) throws NullPointerException {
        if (this.children == null) {
            this.children = new ArrayList<>();
        }
        // is this a root or a pseudo-root
        if (child.parent == null) {
            child.root = false;
            //when building from the ground up
            //todo: clumsy dictionary build: the child dictionary is replaced by a new one!
            if (child.nodeDict != null && child.nodeDict != this.nodeDict) {
                this.nodeDict.putAll(child.getNodeDict());
                child.nodeDict = this.nodeDict;
            } else {//add child to dict
                child.setDict(this.nodeDict, child.getName(), child.getAttributes());
            }
        } else if (child.parent == this) {
            //System.out.println(" parent already set");
            //return ;
        } else {
            throw new IllegalArgumentException("child added but is part of another node tree");
        }
        //System.out.println("adding " + child.getName() + " to " + this.getName());
        this.children.add(child);

    }

    @Override
    public /*NotNull*/ String toString() {
        String valueString ;
        try {
           valueString = String.valueOf(realValue)  ;
        } catch (Exception exc) {
           valueString = "can't trace value [" + exc +"] "  ;
        }
        return String.valueOf(name) + "("
                + valueString + ","
                + String.valueOf(attributes) + ") {"
                + String.valueOf(children) + "}";
    }

    //////////////// TREENODE Contract
    public ComponentNode getChildAt(int childIndex) {
        return children.get(childIndex);
    }

    public int getChildCount() {
        return children.size();
    }

    public T getParent() {
        return parent;
    }

    public int getIndex(ComponentNode node) {
        ComponentNode realNode = (ComponentNode) node ;
        return children.indexOf(realNode);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return (children==null) || (children.isEmpty());
    }

    public Enumeration children() {
        return Collections.enumeration(children);
    }


}
