package org.lsst.ccs.description;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.lsst.ccs.Subsystem;

/**
 * This interface helps find component of the susbsystem
 * as they are defined in the description "tree"
 * @author bamade
 */
// Date: 17/11/12

public interface ComponentLookupService {
    static LinkedHashMap EMPTY = new LinkedHashMap() ;
    /**
     * return any object registered by the dictionaries of the service.
     * Though most are <TT>Configurable</TT> objects of the corresponding <TT>EffectiveNode</TT>
     * In some case a use can register other objects through the <TT>alias</TT> method method
     * @param name
     * @return
     */
    Object getComponentByName(String name) ;
    
    Optional<Subsystem> getSubsystem();

    /**
     * adds an object to a key. implementors should ensure that the corresponding dictionary
     * is different from the top dictionary of the EffectiveNode.
     * @param alias
     * @param component
     */
    void aliasObject(String alias, Object component) ;

    /**
     * gets the children of a Component in the EffectiveNode and filters by Class.
     * BEWARE: the map should be a LinkedHashMap!
     * @param parentName
     * @param classFilter
     * @param <T>
     * @return
     */
    <T> LinkedHashMap<String,T> getChildren(String parentName, Class<T> classFilter) ;

    /**
     *  lists the children of a component.
     * @param parentName
     * @param <T>
     * @return an empty list if there are no children
     */
    <T> List<T> listChildren(String parentName) ;

    /**
     * gets the Parent of a component in the <TT>EffectiveNode</TT> tree.
     * The parent of the top node is named _EDEN_ and has a null value.
     * @param componentName
     * @return
     */
    Map.Entry<String,Object> getParent(String componentName) ;

    /**
     * a default component Lookup service that does not do anything
     */
    public static final ComponentLookupService NONE = new ComponentLookupService() {
        @Override
        public Object getComponentByName(String name) {
            return null;
        }
        
        @Override
        public Optional<Subsystem> getSubsystem(){
            return null;
        }

        @Override
        public void aliasObject(String alias, Object component) {
        }

        //todo: return an empty map
        @Override
        public <T> LinkedHashMap<String, T> getChildren(String parentName, Class<T> classFilter) {
            return EMPTY;
        }

        @Override
        public <T> List<T> listChildren(String parentName) {
            return Collections.EMPTY_LIST;
        }


        // todo: return an empty entry ?  probably not
        @Override
        public Map.Entry<String,Object> getParent(String componentName) {
            return null;
        }
    } ;
}
