package org.lsst.gruth.nodes;

import groovy.util.IndentPrinter;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.MapArgs;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author bamade
 */
public class ComponentTreePrinter {
      protected final IndentPrinter out;

    public ComponentTreePrinter() {
        this(new IndentPrinter(new PrintWriter(new OutputStreamWriter(System.out))));
    }

    public ComponentTreePrinter(PrintWriter out) {
        this(new IndentPrinter(out));
    }

    public ComponentTreePrinter(IndentPrinter out) {
        if (out == null) {
            throw new NullPointerException(" 'out' must not be null!");
        }
        this.out = out;
    }

    public void print(ComponentNode node) {
        out.printIndent();
        printName(node);
        Object value = node.getRealValue();
        boolean hasValue = value != null ;
        out.print(" ( ");
        out.print( String.valueOf( value));
        Map attributes = node.getAttributes();
        boolean hasAttributes = attributes != null && !attributes.isEmpty();
        if (hasAttributes) {
            printAttributes(hasValue, attributes);
        }
        out.println(")");
        ArrayList list = node.getChildren() ;
        if(list != null )  {
            if (list.size() != 0 ) {
                printList(list);
            }
        }
        ComponentNode calls = node.getCalls();
        if(calls != null) {
            print(calls);
        }
        out.flush();
    }

    protected void printName(ComponentNode node) {
        Object name = node.getName();
        if (name != null) {
            out.print("\"" +name.toString() +"\"");
        }
        else {
            out.print("null");
        }
    }

    protected void printList(List list) {
        if (list.isEmpty()) {
            //out.println("");
            out.println();
        }
        else {
            //out.println();
            out.incrementIndent();
            out.printIndent();
            out.println(" {");
            out.incrementIndent();
            for (Iterator iter = list.iterator(); iter.hasNext();) {
                Object value = iter.next();
                if (value instanceof ComponentNode) {
                    print((ComponentNode) value);
                    out.println();
                }
            }
            //out.println();
            out.decrementIndent();
            out.printIndent();
            out.println("}");
            out.decrementIndent();
        }
    }


    protected void printAttributes(boolean hasValue , Map attributes) {
        if( attributes instanceof MapArgs) {
            MapArgs real = (MapArgs) attributes ;
            out.print(real.toString());
        } else {
            printMapAttributes(hasValue, attributes);

        }
    }
    protected void printMapAttributes(boolean hasValue , Map attributes) {
        out.print(", argMap(");
        boolean first = true ;
        for (Iterator iter = attributes.entrySet().iterator(); iter.hasNext();) {
            Map.Entry entry = (Map.Entry) iter.next();
            if (first) {
                first = false;
            }
            else {
                out.print(", ");
            }
            out.print("\"" +entry.getKey().toString() + "\"");
            out.print(":");
            if (entry.getValue() instanceof String) {
                out.print("'" + entry.getValue() + "'");
            }
            else {
                out.print(InvokerHelper.toString(entry.getValue()));
            }
        }
        out.print(" )");
    }


}
