package org.lsst.gruth.jutils;

import org.lsst.gruth.utils.Tracer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * This class is to replace the initial <TT>ComponentNode</TT> class.
 * Each node contains only an actual object that can be used by the application.
 * (contrary to <TT>DescriptiveNode</TT> that contains only a description)
 * @author bamade
 */
// Date: 22/07/2014

public class EffectiveNode extends ComponentNode<EffectiveNode>{
    //todo: add the initialMap from description?
    public EffectiveNode(IndirectMap<String, Object> registry, Object name, String key,  Object value) {
        super(registry, name, key, (Map) null,  value);
    }


    /**
     * @param registry
     * @param children
     * @throws NullPointerException
     * @throws IllegalArgumentException
     */
    public void adoptOrphans(/*NotNull*/IndirectMap<String, Object> registry, /*NotNull*/ArrayList<EffectiveNode> children, EffectiveNode parent)
            throws NullPointerException, IllegalArgumentException {
        for (ComponentNode child : children) {
            child.orphan = false;
            if (child.parent == null) {
                //TODO: verify inconsitencies between keys!
                //TODO: modify in a coherent way with addChild
                if (child.nodeDict != registry) {
                    registry.putAll(child.getNodeDict());
                    child.nodeDict = registry;
                }
                child.parent = parent;
            } else {
                throw new IllegalArgumentException("child added but is part of another node tree");
            }
            child.root = false;
        }
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

    public Object doInvoke(String methodName, Object... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object support = this.getRealValue();
        return invocation(support, methodName, args);

    }

    private Object invocation(Object support, String methodName, Object... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (support != null) {
            /*
             */
            //System.out.println("invocation:" + methodName + Arrays.toString(args));
            //Tracer.trace(Tracer.NODE_CALLS, "invocation:" + methodName + Arrays.toString(args));
            //bizarre bug
            Tracer.trace(Tracer.NODE_CALLS, new Object[]{"invocation:" + methodName + Arrays.toString(args)});
            return MethodsCalls.invokeMethod(support, methodName, args);
            /*
            Class clazz = support.getClass() ;
            Class[] tbargs = new Class[args.length] ;
            for(int ix= 0 ; ix < args.length ; ix++) {
                tbargs[ix] = args[ix].getClass() ;
            }
            Method method = clazz.getMethod(methodName, tbargs) ;
            return method.invoke(support, args) ;
            */
        }
        return null;
    }

    public Object invokeOn(String objectName, String methodName, Object... args) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object obj = this.getIndirect(objectName);
        return invocation(obj, methodName, args);
    }

    public void doCalls() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        //System.out.println("--------< do calls : " +this.getName());
        Object curObj = this.getRealValue();
        if (curObj == null) return;
        if (this.calls != null) {
            ComponentNode topCalls = this.calls;
            List<ComponentNode> children = topCalls.getChildren();
            if (children == null) {
                System.out.println("empty calls node");
                return;
            }
            for (ComponentNode child : children) {
                String methodName = child.getName();
                Map attrib = child.getAttributes();
                if (attrib == null) {
                    invocation(curObj, methodName);
                } else {
                    MapArgs mapArgs = (MapArgs) attrib;
                    if (this.nodeDict instanceof IndirectMap) {
                        //System.out.println("mapArgs" + mapArgs);
                        Object[] args = mapArgs.asFullArray(this.nodeDict);
                        invocation(curObj, methodName, args);
                    }
                }
            }
        }
    }

    public void doCallsFromTop() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        doCalls();
        ArrayList<EffectiveNode> children = this.getChildren();
        if (children == null) return;
        for (EffectiveNode child : children) {
            child.doCallsFromTop();
        }
    }

    public void doCallsFromBase() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        for (EffectiveNode child : this.getChildren()) {
            child.doCalls();
        }
        doCalls();
    }


}
