/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.types.IncompatibleTypeException;

public class ValParm
extends HollowParm {
    private Class actualClass;

    public Class<? extends Serializable> getValueClass() {
        return this.actualClass;
    }

    public ValParm(Serializable object) {
        super(object);
        this.actualClass = object.getClass();
    }

    public ValParm(Serializable object, Map<?, ?> properties) {
        super(object, properties);
        this.actualClass = object.getClass();
    }

    public void setValue(Serializable arg) {
        if (!this.actualClass.isAssignableFrom(arg.getClass())) {
            throw new IncompatibleTypeException(this.actualClass, arg.getClass());
        }
        super.setValue(arg);
    }

    public void setValue(String strVal) {
        this.modifyChecked(strVal);
    }

    public void setValue(Object obj) {
        if (obj instanceof String) {
            this.setValue((String)obj);
        } else if (obj instanceof Serializable) {
            this.setValue((Serializable)obj);
        } else {
            throw new IncompatibleTypeException("not serializable !", this.actualClass, obj.getClass());
        }
    }

    @Override
    public void modifyChecked(Object obj) {
        if (this.readOnly) {
            return;
        }
        if (obj == null) {
            this.setNullValue();
            return;
        }
        if (obj instanceof String) {
            try {
                obj = MethodUtils.invokeStaticMethod((Class)this.actualClass, (String)"valueOf", (Object)((String)obj));
            }
            catch (Exception e) {
                throw new IncompatibleTypeException(e.toString(), this.actualClass, String.class);
            }
        }
        this.setValue(obj);
    }
}

