package org.lsst.gruth.nodes;

import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import org.lsst.gruth.jutils.CallBuilders;
import org.lsst.gruth.jutils.ComponentNode;
import org.lsst.gruth.jutils.DescriptiveNode;

import java.util.Map;

/**
 * though this looks much like <TT>ObjectGraphBuilder</TT>
 * we have slightly different constraints.
 *
 * @author bamade
 */
public class ComponentBuilder extends BuilderSupport {

    static {
        CallBuilders.setCallBuilder(new CallBuilders.CallBuilds() {
            @Override
            public ComponentNode buildCalls(ComponentNode node, Object  obj) {
                if (obj instanceof Closure) {
                    //System.out.println("-----------> invoking calls");
                    Closure closure = (Closure) obj;
                    MethodCallsBuilder builder = new MethodCallsBuilder(node, closure);
                    //Object res = builder.invokeMethod("__calls__", closure);
                    //this.append((Node) res) ;
                    return builder.getCalls();
                }
                return null;
            }
        });
    }

    /*
     public static NodeBuilder newInstance() {
       return new NodeBuilder();
   }

    */
    @Override
    public void setParent(Object o, Object o1) {
        DescriptiveNode parent = (DescriptiveNode) o;
        //System.out.println("set parent :" + parent.getName() + " <- " + ((DescriptiveNode) o1).getName());
        parent.addChild((DescriptiveNode) o1);
    }

    @Override
    public Object createNode(Object name) {
        //return new DescriptiveNode(getCurrentNode(), name, new ArrayList());
        //System.out.println("createNode : parent :" + thisName() + "<- " +name);
        return new DescriptiveNode(getCurrentNode(), name);
    }

    @Override
    public Object createNode(Object name, Object value) {
        //System.out.println("createNode : parent :" + thisName() + "<- " +name +" value:" + value);
        return new DescriptiveNode(getCurrentNode(), name, value);
    }

    @Override
    public Object createNode(Object name, Map attributes) {
        //return new DescriptiveNode(getCurrentNode(), name, attributes, new ArrayList());
        //System.out.println("createNode : parent :" + thisName() + "<- " +name +" attributes:" + attributes);
        return new DescriptiveNode(getCurrentNode(), name, attributes);
    }

    @Override
    public Object createNode(Object name, Map attributes, Object value) {
        /*
        System.out.println("createNode : parent :" + thisName() + "<- " +name
               + " value:" + value
                +" attributes:" + attributes);
          */
        return new DescriptiveNode(getCurrentNode(), name, attributes, value);
    }

    protected DescriptiveNode getCurrentNode() {
        DescriptiveNode current =  (DescriptiveNode) getCurrent();
        //System.out.println("current node " + (current!= null?current.getName(): "null"));
        return current ;
    }

    private String thisName() {
        DescriptiveNode curNode = getCurrentNode();
        if (curNode != null) {
            return curNode.getName();
        }
        return "null";
    }

}
