package org.lsst.gruth.jutils;

import org.lsst.gruth.types.IncompatibleTypeException;

import java.util.Map;

/**
 * @author bamade
 */
public class IntParm extends HollowParm<Integer> {
    public IntParm() {
        super();
    }

    public IntParm(Integer value) {
        super(value);
    }
    public IntParm(Integer value, Map<?,?> map) {
        super(value, map);
    }

    public IntParm(String valStr) throws NumberFormatException {
        super(Integer.parseInt(valStr));
    }
    public IntParm(String valStr, Map<?,?> map) throws NumberFormatException {
        super(Integer.parseInt(valStr), map) ;
    }

    public void setValue(String valStr) throws NumberFormatException {
        if(readOnly) return ;
        super.setValue(Integer.parseInt(valStr));
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    public void modifyChecked(Object obj) {
        if(readOnly) return ;
        if (obj == null) {
            setNullValue();
            return;
        }
        Class clazz = obj.getClass();
        if (Integer.class.equals(clazz)) {
            setValue((Integer) obj);
        } else if (String.class.equals(clazz)) {
            setValue((String) obj);
        } else {
            throw new IncompatibleTypeException(Integer.class, clazz);
        }
    }
}
