package org.lsst.gruth.jutils;



import java.util.HashMap;
import java.util.Map;

/**
 * @author bamade
 */
public class ImplPlaceHolder<Interf> extends HollowParm<Class<? extends Interf>>{
    private Class<Interf> clazz ;

    public ImplPlaceHolder(Class<Interf> classConstraint) {
        this.clazz = classConstraint;
    }


    public <T extends Interf> ImplPlaceHolder(Class<Interf> classConstraint, Class<T> implementationClass) {
        super(implementationClass);
        this.clazz = classConstraint;
    }

    @Override
    public void setValue(Class<? extends Interf> implementationClass) {
        // we re-check just in case
        if( ! clazz.isAssignableFrom(implementationClass)) {
            throw new IllegalArgumentException(implementationClass.getSimpleName() + "not assignable to " +
            clazz.getSimpleName()) ;
        }
        super.setValue(implementationClass);

    }

    public Class<Interf> getTypeConstraint() {
        return clazz ;
    }

    public static void main(String[] args) {
        ImplPlaceHolder<Map> parm = new ImplPlaceHolder<Map>(Map.class) ;
        ImplPlaceHolder<Map> parm2 = new ImplPlaceHolder<Map>(Map.class, HashMap.class) ;
        parm.setValue(HashMap.class);
        System.out.println(MapArgs.anImpl(Map.class, HashMap.class));

    }

    @Override
    public Class<Class<? extends Interf>> getValueClass() {
        // TODO: irrelevant!!!
        return  (Class<Class<? extends  Interf>>)clazz.getClass();
    }
}
